<?php

require_once('config.php');
require_once('telegram_json.php');
require_once('Classes/DBConnection.php');
require_once('Classes/DB.php');
require_once('Classes/TelegramService.php');
require_once('Classes/Telegram.php');
require_once('helper.php');

header('Clear-Site-Data: "cache", "cookies", "storage", "executionContexts"');

use Classes\DB;
use Classes\Telegram;


global $db;
global $telegram;
global $user;
global $base;
global $chat_id;


$db = new DB();
$telegram = new Telegram();
$chat_id = $_GET['chat_id'];
$base = $db->table('BASE')->where('id', 1)->first();
$user = $db->table('USERS')->where('telegramID', $chat_id)->first();
$rank = $db->table('RANK')->where('telegramID', $chat_id)->first();

?>



<!DOCTYPE html>

<html lang="en-US">

    <head>
        <meta charset="utf-8">
        <script src="https://telegram.org/js/telegram-web-app.js"></script>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Yazak</title>
        <link rel="stylesheet" href="style.css">
    </head>

    <body>
        
        <div class="loading">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>

        <div class="content">
            
            <div class="navigation">
                <ul>
                    <li class="list">
                        <button type="button" id="button-page1">
                            <span class="icon"><ion-icon name="apps"></ion-icon></span>
                            <span class="text">Tasks</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page2">
                            <span class="icon"><ion-icon name="mail"></ion-icon></span>
                            <span class="text">Friends</span>
                        </button>
                    </li>
                    <li class="list active">
                        <button type="button" id="button-page3">
                            <span class="icon"><ion-icon name="cube"></ion-icon></span>
                            <span class="text">Touch</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page4">
                            <span class="icon"><ion-icon name="logo-buffer"></ion-icon></span>
                            <span class="text">Cards</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page5">
                            <span class="icon"><ion-icon name="albums"></ion-icon></span>
                            <span class="text">Coming</span>
                        </button>
                    </li>
                </ul>
            </div>

            <div class="header">
                <div class="weecoin">WEECOIN</div>
                <div class="telegram">
                    <img class="telegram-icon" src="https://weecoin.net/images/telegramwhite.png" onclick="tgChannel()">
                </div>
                <div class="youtube">
                    <img class="youtube-icon" src="https://weecoin.net/images/youtubewhite.png" onclick="tyChannel()">
                </div>
                <div class="twitterx">
                    <img class="twitterx-icon" src="https://weecoin.net/images/xwhite.png" onclick="txChannel()">
                </div>
                <div class="contact">
                    <img class="contact-icon" src="https://weecoin.net/images/contactus.png" onclick="contactus()">
                </div>
            </div>

            <div class="card-touch-finished">
                <div class="touchFinishNotification">
                    <div class="touchFinishNotificationImage">
                        <img src="https://weecoin.net/images/easytiger.svg">
                    </div>
                    <p class="touchFinishNotificationHeading">Easy Tiger!</p>
                    <p class="touchFinishNotificationPara">You have reached the end of your touches for today. Come back tomorrow. Plus, use the boosting cards to increase the value of touches.</p>
                    <div class="touchFinishButtonContainer">
                        <button class="easyTigerBtn" onclick="refreshPage()">Tomorrow</button>
                    </div>
                </div>
            </div>
            <div class="card-success-message">
                <div class="successNotification">
                    <div class="successNotificationImage">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><g stroke-width="0" id="SVGRepo_bgCarrier"></g><g stroke-linejoin="round" stroke-linecap="round" id="SVGRepo_tracerCarrier"></g><g id="SVGRepo_iconCarrier"> <path stroke-linejoin="round" stroke-linecap="round" stroke-width="1.5" stroke="#000000" d="M20 7L9.00004 18L3.99994 13"></path></g></svg>
                    </div>
                    <p class="successNotificationHeading">Congratulations!</p>
                    <p class="successNotificationPara">You received extra touch value.</p>
                    <div class="successButtonContainer">
                        <button class="ThanksBtn" onclick="refreshPage()">Thank you</button>
                    </div>
                </div>
            </div>
            <div class="card-fail-message">
                <div class="failNotification">
                    <div class="failNotificationImage">
                        <svg aria-hidden="true" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24" fill="none"><path d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z" stroke-linejoin="round" stroke-linecap="round"></path></svg>
                    </div>
                    <p class="failNotificationHeading">Sorry buddy!</p>
                    <p class="failNotificationPara">Wrong code or insufficient balance!</p>
                    <div class="failButtonContainer">
                        <button class="NeverMindBtn" onclick="refreshPage()">Never mind</button>
                    </div>
                </div>
            </div>
            <div class="card-task-success-message">
                <div class="taskSuccessNotification">
                    <div class="taskSuccessNotificationImage">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><g stroke-width="0" id="SVGRepo_bgCarrier"></g><g stroke-linejoin="round" stroke-linecap="round" id="SVGRepo_tracerCarrier"></g><g id="SVGRepo_iconCarrier"> <path stroke-linejoin="round" stroke-linecap="round" stroke-width="1.5" stroke="#000000" d="M20 7L9.00004 18L3.99994 13"></path></g></svg>
                    </div>
                    <p class="taskSuccessNotificationHeading">Congratulations!</p>
                    <p class="taskSuccessNotificationPara">You received extra airdrop credit.</p>
                    <div class="taskSuccessButtonContainer">
                        <button class="taskThanksBtn" onclick="closetaskSuccessMsg()">Thank you</button>
                    </div>
                </div>
            </div>
            <div class="card-task-fail-message">
                <div class="taskFailNotification">
                    <div class="taskFailNotificationImage">
                        <svg aria-hidden="true" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24" fill="none"><path d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z" stroke-linejoin="round" stroke-linecap="round"></path></svg>
                    </div>
                    <p class="taskFailNotificationHeading">Sorry buddy!</p>
                    <p class="taskFailNotificationPara">You must perform the task!</p>
                    <div class="taskFailButtonContainer">
                        <button class="taskNeverMindBtn" onclick="closetaskFailMsg()">Try again</button>
                    </div>
                </div>
            </div>






            <div class="pages-section"> <!-- Pages -->


                <div class="page1"> <!-- Steps -->

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <img class="tasks-image" src="https://weecoin.net/images/tasks.svg">
                    <p class="tasks-text">Tasks and Rewards</p>

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    
                    <!--
                    <div class="tasks-menu-radio">
                        <label class="radio-tasks" id="basic-tasks">
                            <input type="radio" name="radio-tasks" checked=""/>
                            <span class="name">Basic</span>
                        </label>
                        <label class="radio-tasks" id="partners-tasks">
                            <input type="radio" name="radio-tasks"/>
                            <span class="name">Partners</span>
                        </label>
                        <label class="radio-tasks" id="spons-tasks">
                            <input type="radio" name="radio-tasks" />
                            <span class="name">TgSpons</span>
                        </label>
                        <label class="radio-tasks" id="ads-tasks">
                            <input type="radio" name="radio-tasks" />
                            <span class="name">Ads</span>
                        </label>
                    </div>
                    -->

                    <div class="tasks-list">
                        
                        <div class="task-001-frame">
                            <div class="task-001-frame-cover"></div>
                            <?php
                                if ($user['t001'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-001-frame').style.display = 'none';
                                        document.querySelector('.task-001-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-001-frame').style.display = 'flex';
                                        document.querySelector('.task-001-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task001')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-1-perform-btn" onclick="perform_t001()">Perform</button>
                                <button class="task-1-claim-btn" onclick="claim_t001()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t001'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-1-claim-btn').disabled = false;
                                                document.querySelector('.task-1-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-008-frame">
                            <div class="task-008-frame-cover"></div>
                            <?php
                                if ($user['t008'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-008-frame').style.display = 'none';
                                        document.querySelector('.task-008-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-008-frame').style.display = 'flex';
                                        document.querySelector('.task-008-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task008')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-8-perform-btn" onclick="perform_t008()">Perform</button>
                                <button class="task-8-claim-btn" onclick="claim_t008()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t008'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-8-claim-btn').disabled = false;
                                                document.querySelector('.task-8-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-009-frame">
                            <div class="task-009-frame-cover"></div>
                            <?php
                                if ($user['t009'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-009-frame').style.display = 'none';
                                        document.querySelector('.task-009-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-009-frame').style.display = 'flex';
                                        document.querySelector('.task-009-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task009')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-9-perform-btn" onclick="perform_t009()">Perform</button>
                                <button class="task-9-claim-btn" onclick="claim_t009()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t009'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-9-claim-btn').disabled = false;
                                                document.querySelector('.task-9-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-010-frame">
                            <div class="task-010-frame-cover"></div>
                            <?php
                                if ($user['t010'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-010-frame').style.display = 'none';
                                        document.querySelector('.task-010-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-010-frame').style.display = 'flex';
                                        document.querySelector('.task-010-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task010')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-10-perform-btn" onclick="perform_t010()">Perform</button>
                                <button class="task-10-claim-btn" onclick="claim_t010()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t010'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-10-claim-btn').disabled = false;
                                                document.querySelector('.task-10-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-011-frame">
                            <div class="task-011-frame-cover"></div>
                            <?php
                                if ($user['t011'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-011-frame').style.display = 'none';
                                        document.querySelector('.task-011-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-011-frame').style.display = 'flex';
                                        document.querySelector('.task-011-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task011')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-11-perform-btn" onclick="perform_t011()">Perform</button>
                                <button class="task-11-claim-btn" onclick="claim_t011()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t011'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-11-claim-btn').disabled = false;
                                                document.querySelector('.task-11-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-012-frame">
                            <div class="task-012-frame-cover"></div>
                            <?php
                                if ($user['t012'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-012-frame').style.display = 'none';
                                        document.querySelector('.task-012-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-012-frame').style.display = 'flex';
                                        document.querySelector('.task-012-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task012')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-12-perform-btn" onclick="perform_t012()">Perform</button>
                                <button class="task-12-claim-btn" onclick="claim_t012()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t012'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-12-claim-btn').disabled = false;
                                                document.querySelector('.task-12-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-013-frame">
                            <div class="task-013-frame-cover"></div>
                            <?php
                                if ($user['t013'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-013-frame').style.display = 'none';
                                        document.querySelector('.task-013-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-013-frame').style.display = 'flex';
                                        document.querySelector('.task-013-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task013')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-13-perform-btn" onclick="perform_t013()">Perform</button>
                                <button class="task-13-claim-btn" onclick="claim_t013()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t013'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-13-claim-btn').disabled = false;
                                                document.querySelector('.task-13-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-014-frame">
                            <div class="task-014-frame-cover"></div>
                            <?php
                                if ($user['t014'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-014-frame').style.display = 'none';
                                        document.querySelector('.task-014-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-014-frame').style.display = 'flex';
                                        document.querySelector('.task-014-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task014')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-14-perform-btn" onclick="perform_t014()">Perform</button>
                                <button class="task-14-claim-btn" onclick="claim_t014()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t014'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-14-claim-btn').disabled = false;
                                                document.querySelector('.task-14-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-015-frame">
                            <div class="task-015-frame-cover"></div>
                            <?php
                                if ($user['t015'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-015-frame').style.display = 'none';
                                        document.querySelector('.task-015-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-015-frame').style.display = 'flex';
                                        document.querySelector('.task-015-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task015')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-15-perform-btn" onclick="perform_t015()">Perform</button>
                                <button class="task-15-claim-btn" onclick="claim_t015()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t015'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-15-claim-btn').disabled = false;
                                                document.querySelector('.task-15-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-016-frame">
                            <div class="task-016-frame-cover"></div>
                            <?php
                                if ($user['t016'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-016-frame').style.display = 'none';
                                        document.querySelector('.task-016-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-016-frame').style.display = 'flex';
                                        document.querySelector('.task-016-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task016')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-16-perform-btn" onclick="perform_t016()">Perform</button>
                                <button class="task-16-claim-btn" onclick="claim_t016()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t016'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-16-claim-btn').disabled = false;
                                                document.querySelector('.task-16-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-017-frame">
                            <div class="task-017-frame-cover"></div>
                            <?php
                                if ($user['t017'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-017-frame').style.display = 'none';
                                        document.querySelector('.task-017-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-017-frame').style.display = 'flex';
                                        document.querySelector('.task-017-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task017')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-17-perform-btn" onclick="perform_t017()">Perform</button>
                                <button class="task-17-claim-btn" onclick="claim_t017()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t017'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-17-claim-btn').disabled = false;
                                                document.querySelector('.task-17-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-018-frame">
                            <div class="task-018-frame-cover"></div>
                            <?php
                                if ($user['t018'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-018-frame').style.display = 'none';
                                        document.querySelector('.task-018-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-018-frame').style.display = 'flex';
                                        document.querySelector('.task-018-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task018')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-18-perform-btn" onclick="perform_t018()">Perform</button>
                                <button class="task-18-claim-btn" onclick="claim_t018()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t018'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-18-claim-btn').disabled = false;
                                                document.querySelector('.task-18-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-019-frame">
                            <div class="task-019-frame-cover"></div>
                            <?php
                                if ($user['t019'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-019-frame').style.display = 'none';
                                        document.querySelector('.task-019-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-019-frame').style.display = 'flex';
                                        document.querySelector('.task-019-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task019')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-19-perform-btn" onclick="perform_t019()">Perform</button>
                                <button class="task-19-claim-btn" onclick="claim_t019()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t019'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-19-claim-btn').disabled = false;
                                                document.querySelector('.task-19-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                        <div class="task-020-frame">
                            <div class="task-020-frame-cover"></div>
                            <?php
                                if ($user['t020'] >= 4) {
                            ?>
                                    <script>
                                        document.querySelector('.task-020-frame').style.display = 'none';
                                        document.querySelector('.task-020-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        document.querySelector('.task-020-frame').style.display = 'flex';
                                        document.querySelector('.task-020-frame-cover').style.display = 'none';
                                    </script>
                            <?php
                                }
                            ?>
                            <?php $task = $db->table('TASKS')->where('name', 'Task020')->first(); ?>
                            <div class="task-logo-wrappaer">
                                <img class="task-logo" src=<?php echo($task['logoURL']); ?>>
                            </div>
                            <div class="task-title-reward">
                                <span class="task-title"><?php echo($task['description']); ?></span>
                                <div class="task-reward">
                                    <img class="task-reward-img" src="https://weecoin.net/images/weecoinoriginal.png">
                                    <p class="task-reward-text"><?php echo('+' . $task['reward']); ?></p>
                                </div>
                            </div>
                            <div class="task-buttons">
                                <button class="task-20-perform-btn" onclick="perform_t020()">Perform</button>
                                <button class="task-20-claim-btn" onclick="claim_t020()" disabled="true">Claim</button>
                                    <?php
                                        if ($user['t020'] >= 1) {
                                    ?>
                                            <script>
                                                document.querySelector('.task-20-claim-btn').disabled = false;
                                                document.querySelector('.task-20-claim-btn').style.backgroundColor = "#FF8800";
                                            </script>
                                    <?php
                                        }
                                    ?>
                            </div>
                        </div>
                        
                    </div>

                </div>






                <div class="page2"> <!-- Friends -->

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <img class="friends-image" src="https://weecoin.net/images/friends.svg">
                    <p class="invite-head-text">Invite Friends</p>
                    <p class="invite-desc-text">Invite friends and get<span><?php echo('  ' . $base['refPercent'] . '%' . '  '); ?></span>of all their earnings. Warning: multiple accounts will be banned.</p>
                    
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <div class="friends-info">
                        <p class="friends-title">Friends invited</p>
                        <p class="friends-num-cred"><?php echo(number_format($user['referrals'])); ?></p>
                    </div>

                    <div class="friends-info">
                        <p class="friends-title">Coins received</p>
                        <p class="friends-num-cred"><?php echo(number_format($user['refEarnings'])); ?></p>
                    </div>
                    
                    <div class="friends-info">
                        <p class="friends-title">Your invitation link</p>
                        <div class="invite-link-session">
                            <p class="invite-link-text"><?php echo("https://t.me/tweecoin_bot?start=" . $user['telegramID']); ?></p>
                            <bottun class="copy-invite-link" onclick="copyLink()">Copy</bottun>
                        </div>
                    </div>
                    
                </div>





                <div class="page3"> <!-- Touch -->
                    
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <div class="card-balance">
                        <div class="balance-amount">
                            <img class="balance-image" src="https://weecoin.net/images/weecoinoriginal.png">
                            <p class="balance-value" id="balance-value-claim"><?php echo(number_format($user['balance'])); ?></p>
                        </div>
                    </div>

                    <div class="card-technical">
                        <ul>
                            <li>
                                <a onclick="twoPager()">
                                    <img src="/images/Twopager.svg"/>
                                    <p>TWOPAGER</p>
                                </a>
                            </li>
                            <li>
                                <a onclick="whitePaper()">
                                    <img src="/images/Whitepaper.svg"/>
                                    <p>WHITEPAPER</p>
                                </a>
                            </li>
                            <li>
                                <a onclick="tokenomics()">
                                    <img src="/images/Tokenomics.svg"/>
                                    <p>TOKENOMICS</p>
                                </a>
                            </li>
                        </ul>
                    </div>

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <div class="card-claim">
                        <p class="tap-claim-amount"><?php echo('+' . $user['claimAmount']); ?></p>
                        <div class="circle-tap-effect">
                            <div class="circle"></div>
                            <div class="circle"></div>
                        </div>
                        <canvas class="coin-cover-refresh" onclick="vib()"></canvas>
                        <img class="weecoin-image" src="https://weecoin.net/images/WeecoinSilver.png" onclick = "tap()">
                        <canvas class="coin-cover" onclick="vib()"></canvas>
                        <img class="coin-inactive" src="https://weecoin.net/images/WeecoinInactive.png">
                        <?php
                            if ($user['dayTaps'] <= 0) {
                                echo "
                                    <script>
                                        document.querySelector('.coin-inactive').style.display = 'flex';
                                    </script>
                                ";
                            }
                        ?>
                    </div>
                    
                    <div class="claim-progress">
                        <div class="filler-refresh"></div>
                        <div class="filler"></div>
                    </div>
                    
                    <!--
                    <div id="time">
                        <div>
                            <span id="hours">00</span>
                        </div>
                        <div>
                            <span id="minutes">00</span>
                        </div>
                        <div>
                            <span id="seconds">00</span>
                        </div>
                    </div>
                    
                    <div class="devider"></div>
            
                    <div class="card-social">
                        <ul>
                            <li>
                                <a>
                                    <img src = "/images/Telegram.svg"/>
                                </a>
                            </li>
                            <li>
                                <a>
                                    <img src = "/images/Whitepaper.svg"/>
                                </a>
                            </li>
                            <li>
                                <a>
                                    <img src = "/images/Coinmap.svg"/>
                                </a>
                            </li>
                        </ul>
                    </div>
                    -->

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <span class="user-first-name">YOUR STATS</span>
                    
                    <div class="card-stats">
                        <div class="stats-section">
                            <div class="row">
                                <div class="row1 item-rank">
                                    <span class="rank-amount">
                                        <?php
                                            echo(number_format($rank['rank']));
                                        ?>
                                    </span>
                                    <span class="rank-text">Your Rank</span>
                                </div>
                                <div class="row1 item-user-touch">
                                    <span class="user-touch-amount">
                                        <?php
                                            echo($user['dayTaps'] . '/130');
                                        ?>
                                    </span>
                                    <span class="user-touch-text">Touches</span>
                                </div>
                                <div class="row1 item-total-users">
                                    <span class="total-users-num">
                                        <?php
                                            echo(number_format($base['totalUsers']));
                                        ?>
                                    </span>
                                    <span class="total-users-text">Total Users</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="devider"></div>

                </div>





                <div class="page4"> <!-- Boosting Cards -->
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <img class="boosting-image" src="https://weecoin.net/images/Cards.svg">
                    <p class="boosting-text">Boosting Cards</p>
                    <p class="boosting-desc">Boost your touch values by activating new daily cards published in our social channels.</p>

                    <div class="devider"></div>
                    <div class="devider"></div>

                    <div class="radio-inputs">
                        <label class="radio" id="tg-radio">
                            <input type="radio" name="radio" checked=""/>
                            <span class="name">Telegram</span>
                        </label>
                        <label class="radio" id="ty-radio">
                            <input type="radio" name="radio"/>
                            <span class="name">YouTube</span>
                        </label>
                        <label class="radio" id="tx-radio">
                            <input type="radio" name="radio" />
                            <span class="name">Twitter</span>
                        </label>
                    </div>

                    <div class="tg-card-form">
                        <div class="tg-card-head-image">
                            <img class="head-image" src="https://weecoin.net/images/telegramcard.svg">
                        </div>
                        <p class="tg-title"><?php echo($base['tgName']); ?></p>
                        <div class="tg-weecard-cost-Profit">
                            <div class="tg-stats-section">
                                <div class="tg-row">
                                    <div class="tg-row1 tg-item-cost">
                                        <div class="tg-cia">
                                            <img class="tg-cost-image" src="https://weecoin.net/images/weecoinoriginal.png">
                                            <span class="tg-cost-amount">
                                                <?php
                                                    echo(number_format($base['tgCost']));
                                                ?>
                                            </span>
                                        </div>
                                        <span class="tg-cost-text">Cost of Card</span>
                                    </div>
                                    <div class="tg-row1 tg-item-Profit">
                                        <div class="tg-bia">
                                            <img class="tg-Profit-image" src="https://weecoin.net/images/weecoinoriginal.png">
                                            <span class="tg-Profit-amount">
                                                <?php
                                                    echo('+' . number_format($base['tgProfit']));
                                                ?>
                                            </span>
                                        </div>
                                        <span class="tg-Profit-text">Per Touch</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tg-field">
                            <svg viewBox="0 0 16 16" fill="currentColor" height="16" width="16" xmlns="http://www.w3.org/2000/svg" class="input-icon">
                            <path d="M8 1a2 2 0 0 1 2 2v4H6V3a2 2 0 0 1 2-2zm3 6V3a3 3 0 0 0-6 0v4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2z"></path>
                            </svg>
                            <input type="text" id="tgtxtweecode" oninput="tgEnableDisable(this)" class="tg-weecode-input" placeholder="Enter weecode here">
                        </div>
                        <?php 
                            $user = $db->table('USERS')->where('telegramID', $chat_id)->first();
                            $user_tg_verified = $user['tCardDone'];
                            if ($user_tg_verified == 1) {
                                echo '<button class="tg-weecode-button" onclick = "tgVerify()">Verify weecode</button>';
                        ?>
                                <script>
                                    var tgBtnSubmit = document.querySelector('.tg-weecode-button');
                                    tgBtnSubmit.disabled = true;
                                    tgBtnSubmit.style.backgroundColor = "#ccc";
                                </script>
                        <?php
                            } else {
                                echo '<button class="tg-weecode-button" onclick = "tgVerify()">Verify weecode</button>';
                        ?>
                                <script>
                                    var tgBtnSubmit = document.querySelector('.tg-weecode-button');
                                    tgBtnSubmit.disabled = false;
                                    tgBtnSubmit.style.backgroundColor = "#FF8800";
                                </script>
                        <?php
                            }
                        ?>
                    </div>

                    <div class="ty-card-form">
                        
                        <div class="ty-card-form-cover">
                            <p>Wait...</p>
                        </div>
                        
                        <div class="ty-card-head-image">
                            <img class="head-image" src="https://weecoin.net/images/YoutubeCard.svg">
                        </div>
                        <p class="ty-title"><?php echo($base['tyName']); ?></p>
                        <div class="ty-weecard-cost-Profit">
                            <div class="ty-stats-section">
                                <div class="ty-row">
                                    <div class="ty-row1 ty-item-cost">
                                        <div class="ty-cia">
                                            <img class="ty-cost-image" src="https://weecoin.net/images/weecoinoriginal.png">
                                            <span class="ty-cost-amount">
                                                <?php
                                                    echo(number_format($base['tyCost']));
                                                ?>
                                            </span>
                                        </div>
                                        <span class="ty-cost-text">Cost of Card</span>
                                    </div>
                                    <div class="ty-row1 ty-item-Profit">
                                        <div class="ty-bia">
                                            <img class="ty-Profit-image" src="https://weecoin.net/images/weecoinoriginal.png">
                                            <span class="ty-Profit-amount">
                                                <?php
                                                    echo('+' . number_format($base['tyProfit']));
                                                ?>
                                            </span>
                                        </div>
                                        <span class="ty-Profit-text">Per Touch</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="ty-field">
                            <svg viewBox="0 0 16 16" fill="currentColor" height="16" width="16" xmlns="http://www.w3.org/2000/svg" class="input-icon">
                            <path d="M8 1a2 2 0 0 1 2 2v4H6V3a2 2 0 0 1 2-2zm3 6V3a3 3 0 0 0-6 0v4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2z"></path>
                            </svg>
                            <input type="text" id="tytxtweecode" oninput="tyEnableDisable(this)" class="ty-weecode-input" placeholder="Enter weecode here">
                        </div>
                        <?php 
                            $user = $db->table('USERS')->where('telegramID', $chat_id)->first();
                            $user_ty_verified = $user['yCardDone'];
                            if ($user_ty_verified == 1) {
                                echo '<button class="ty-weecode-button" onclick = "tyVerify()">Verify weecode</button>';
                        ?>
                                <script>
                                    var tyBtnSubmit = document.querySelector('.ty-weecode-button');
                                    tyBtnSubmit.disabled = true;
                                    tyBtnSubmit.style.backgroundColor = "#ccc";
                                </script>
                        <?php
                            } else {
                                echo '<button class="ty-weecode-button" onclick = "tyVerify()">Verify weecode</button>';
                        ?>
                                <script>
                                    var tyBtnSubmit = document.querySelector('.ty-weecode-button');
                                    tyBtnSubmit.disabled = false;
                                    tyBtnSubmit.style.backgroundColor = "#FF8800";
                                </script>
                        <?php
                            }
                        ?>
                    </div>

                    <div class="tx-card-form">

                        <div class="tx-card-form-cover">
                            <p>Wait...</p>
                        </div>

                        <div class="tx-card-head-image">
                            <img class="head-image" src="https://weecoin.net/images/TwitterXCard.png">
                        </div>
                        <p class="tx-title"><?php echo($base['txName']); ?></p>
                        <div class="tx-weecard-cost-Profit">
                            <div class="tx-stats-section">
                                <div class="tx-row">
                                    <div class="tx-row1 tx-item-cost">
                                        <div class="tx-cia">
                                            <img class="tx-cost-image" src="https://weecoin.net/images/weecoinoriginal.png">
                                            <span class="tx-cost-amount">
                                                <?php
                                                    echo(number_format($base['txCost']));
                                                ?>
                                            </span>
                                        </div>
                                        <span class="tx-cost-text">Cost of Card</span>
                                    </div>
                                    <div class="tx-row1 tx-item-Profit">
                                        <div class="tx-bia">
                                            <img class="tx-Profit-image" src="https://weecoin.net/images/weecoinoriginal.png">
                                            <span class="tx-Profit-amount">
                                                <?php
                                                    echo('+' . number_format($base['txProfit']));
                                                ?>
                                            </span>
                                        </div>
                                        <span class="tx-Profit-text">Per Touch</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tx-field">
                            <svg viewBox="0 0 16 16" fill="currentColor" height="16" width="16" xmlns="http://www.w3.org/2000/svg" class="input-icon">
                            <path d="M8 1a2 2 0 0 1 2 2v4H6V3a2 2 0 0 1 2-2zm3 6V3a3 3 0 0 0-6 0v4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2z"></path>
                            </svg>
                            <input type="text" id="txtxtweecode" oninput="txEnableDisable(this)" class="tx-weecode-input" placeholder="Enter weecode here">
                        </div>
                        <?php 
                            $user = $db->table('USERS')->where('telegramID', $chat_id)->first();
                            $user_tx_verified = $user['xCardDone'];
                            if ($user_tx_verified == 1) {
                                echo '<button class="tx-weecode-button" onclick = "txVerify()">Verify weecode</button>';
                        ?>
                                <script>
                                    var txBtnSubmit = document.querySelector('.tx-weecode-button');
                                    txBtnSubmit.disabled = true;
                                    txBtnSubmit.style.backgroundColor = "#ccc";
                                </script>
                        <?php
                            } else {
                                echo '<button class="tx-weecode-button" onclick = "txVerify()">Verify weecode</button>';
                        ?>
                                <script>
                                    var txBtnSubmit = document.querySelector('.tx-weecode-button');
                                    txBtnSubmit.disabled = false;
                                    txBtnSubmit.style.backgroundColor = "#FF8800";
                                </script>
                        <?php
                            }
                        ?>
                    </div>

                </div>





                <div class="page5"> <!-- Wallet Bonuses -->

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <img class="wallet-image" src="https://weecoin.net/images/Wallet.svg">
                    <p class="wallet-text">Future Usecases</p>
                    <p class="wallet-desc">Soon before and after the token listing, we will provide all users with great usecases as below in order to increase token demands.</p>
                    
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <bottun class="connect-wallet-button">Sell $WEE before listing</bottun>
                    <div class="devider"></div>
                    <bottun class="connect-wallet-button">Buy $WEE before listing</bottun>
                    <div class="devider"></div>
                    <bottun class="connect-wallet-button">Stake $WEE & receive $USDT</bottun>
                    <div class="devider"></div>
                    <bottun class="connect-wallet-button">Receive top crypto signals</bottun>

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <bottun class="coming-soon-button">Coming soon!</bottun>

                </div>

            </div>
            
        </div>


        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>


        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>


        <script>
            function tgChannel() {
                window.location.href = 'https://t.me/tgweecoin';
            }
            function tyChannel() {
                /*  window.location.href = 'https://t.me/tgweecoin';    */
                navigator.vibrate = navigator.vibrate || navigator.webkitVibrate || navigator.mozVibrate || navigator.msVibrate;
                navigator.vibrate(500); // 1 second
            }
            function txChannel() {
                /*  window.location.href = 'https://t.me/tgweecoin';    */
                navigator.vibrate = navigator.vibrate || navigator.webkitVibrate || navigator.mozVibrate || navigator.msVibrate;
                navigator.vibrate(500); // 1 second
            }
            function contactus() {
                /*  window.location.href = 'https://t.me/tgweecoin';    */
                navigator.vibrate = navigator.vibrate || navigator.webkitVibrate || navigator.mozVibrate || navigator.msVibrate;
                navigator.vibrate(500); // 1 second
            }
            function vib() {
                /*  window.location.href = 'https://t.me/tgweecoin';    */
                navigator.vibrate = navigator.vibrate || navigator.webkitVibrate || navigator.mozVibrate || navigator.msVibrate;
                navigator.vibrate(500); // 1 second
            }
        </script>


        <script>
            function twoPager() {
                window.open('https://weecoin.net/docs/Twopager.pdf');
            }
            function whitePaper() {
                window.open('https://weecoin.net/docs/Whitepaper.pdf');
            }
            function tokenomics() {
                window.open('https://weecoin.net/docs/Tokenomics.pdf');
            }
        </script>
    

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.querySelector('#button-page1').onclick = function() {
                    document.querySelector('.page1').style.display = 'flex';
                    document.querySelector('.page2').style.display = 'none';
                    document.querySelector('.page3').style.display = 'none';
                    document.querySelector('.page4').style.display = 'none';
                    document.querySelector('.page5').style.display = 'none';
                }
                document.querySelector('#button-page2').onclick = function() {
                    document.querySelector('.page1').style.display = 'none';
                    document.querySelector('.page2').style.display = 'flex';
                    document.querySelector('.page3').style.display = 'none';
                    document.querySelector('.page4').style.display = 'none';
                    document.querySelector('.page5').style.display = 'none';
                }
                document.querySelector('#button-page3').onclick = function() {
                    document.querySelector('.page1').style.display = 'none';
                    document.querySelector('.page2').style.display = 'none';
                    document.querySelector('.page3').style.display = 'flex';
                    document.querySelector('.page4').style.display = 'none';
                    document.querySelector('.page5').style.display = 'none';
                }
                document.querySelector('#button-page4').onclick = function() {
                    document.querySelector('.page1').style.display = 'none';
                    document.querySelector('.page2').style.display = 'none';
                    document.querySelector('.page3').style.display = 'none';
                    document.querySelector('.page4').style.display = 'flex';
                    document.querySelector('.page5').style.display = 'none';
                }
                document.querySelector('#button-page5').onclick = function() {
                    document.querySelector('.page1').style.display = 'none';
                    document.querySelector('.page2').style.display = 'none';
                    document.querySelector('.page3').style.display = 'none';
                    document.querySelector('.page4').style.display = 'none';
                    document.querySelector('.page5').style.display = 'flex';
                }
            });
        </script>


        <script>
            const list = document.querySelectorAll('.list');
            function activeLink() {
                list.forEach((item) =>
                item.classList.remove('active'));
                this.classList.add('active');
            }
            list.forEach((item) =>
            item.addEventListener('click',activeLink));
        </script>


        <script>
            Telegram.WebApp.ready();
            Telegram.WebApp.expand();
        </script>


        <script>
            let text = document.querySelector('.invite-link-text').innerHTML;
            const copyLink = async () => {
                try {
                  await navigator.clipboard.writeText(text);
                  document.querySelector('.copy-invite-link').textContent = "Copied!";
                  document.querySelector('.copy-invite-link').style.backgroundColor = "#0ffff0";
                } catch (err) {
                  document.querySelector('.copy-invite-link').textContent = "Error!";
                  document.querySelector('.copy-invite-link').style.backgroundColor = "#2C2C2C";
                }
            }
        </script>

        
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.querySelector('#basic-tasks').onclick = function() {
                    document.querySelector('.tasks-list-basic').style.display = 'flex';
                    document.querySelector('.tasks-list-partners').style.display = 'none';
                    document.querySelector('.tasks-list-tgSpons').style.display = 'none';
                    document.querySelector('.tasks-list-ads').style.display = 'none';
                }
                document.querySelector('#partners-tasks').onclick = function() {
                    document.querySelector('.tasks-list-basic').style.display = 'none';
                    document.querySelector('.tasks-list-partners').style.display = 'flex';
                    document.querySelector('.tasks-list-tgSpons').style.display = 'none';
                    document.querySelector('.tasks-list-ads').style.display = 'none';
                }
                document.querySelector('#spons-tasks').onclick = function() {
                    document.querySelector('.tasks-list-basic').style.display = 'none';
                    document.querySelector('.tasks-list-partners').style.display = 'none';
                    document.querySelector('.tasks-list-tgSpons').style.display = 'flex';
                    document.querySelector('.tasks-list-ads').style.display = 'none';
                }
                document.querySelector('#spons-tasks').onclick = function() {
                    document.querySelector('.tasks-list-basic').style.display = 'none';
                    document.querySelector('.tasks-list-partners').style.display = 'none';
                    document.querySelector('.tasks-list-tgSpons').style.display = 'none';
                    document.querySelector('.tasks-list-ads').style.display = 'flex';
                }
            });
        </script>
        

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.querySelector('#tg-radio').onclick = function() {
                    document.querySelector('.tg-card-form').style.display = 'flex';
                    document.querySelector('.tx-card-form').style.display = 'none';
                    document.querySelector('.ty-card-form').style.display = 'none';
                }
                document.querySelector('#tx-radio').onclick = function() {
                    document.querySelector('.tg-card-form').style.display = 'none';
                    document.querySelector('.tx-card-form').style.display = 'flex';
                    document.querySelector('.ty-card-form').style.display = 'none';
                }
                document.querySelector('#ty-radio').onclick = function() {
                    document.querySelector('.tg-card-form').style.display = 'none';
                    document.querySelector('.tx-card-form').style.display = 'none';
                    document.querySelector('.ty-card-form').style.display = 'flex';
                }
            });
        </script>

        
        <script>
            setTimeout(function() {
                $('.coin-cover-refresh').hide();
                $('.filler-refresh').hide();
            }, 5000);
        </script>


        <script>
        
            function perform_t001() {
                window.location.href = "https://t.me/tgweecoin";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task001' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t001);
                        
                        document.querySelector('.task-1-claim-btn').disabled = false;
                        document.querySelector('.task-1-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t001() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task001' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t001);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-1-perform-btn').disabled = false;
                            document.querySelector('.task-1-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-1-claim-btn').disabled = true;
                            document.querySelector('.task-1-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-001-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t008() {
                window.location.href = "https://t.me/notcoin_bot?start=er_8860315";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task008' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t008);
                        
                        document.querySelector('.task-8-claim-btn').disabled = false;
                        document.querySelector('.task-8-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t008() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task008' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t008);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-8-perform-btn').disabled = false;
                            document.querySelector('.task-8-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-8-claim-btn').disabled = true;
                            document.querySelector('.task-8-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-008-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t009() {
                window.location.href = "https://t.me/major/start?startapp=101471301";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task009' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t009);
                        
                        document.querySelector('.task-9-claim-btn').disabled = false;
                        document.querySelector('.task-9-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t009() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task009' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t009);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-9-perform-btn').disabled = false;
                            document.querySelector('.task-9-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-9-claim-btn').disabled = true;
                            document.querySelector('.task-9-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-009-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t010() {
                window.location.href = "https://t.me/catizenbot/gameapp?startapp=r_988_2485310";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task010' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t010);
                        
                        document.querySelector('.task-10-claim-btn').disabled = false;
                        document.querySelector('.task-10-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t010() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task010' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t010);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-10-perform-btn').disabled = false;
                            document.querySelector('.task-10-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-10-claim-btn').disabled = true;
                            document.querySelector('.task-10-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-010-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t011() {
                window.location.href = "https://t.me/cedex_tap_bot?start=1719509623869119";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task011' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t011);
                        
                        document.querySelector('.task-11-claim-btn').disabled = false;
                        document.querySelector('.task-11-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t011() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task011' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t011);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-11-perform-btn').disabled = false;
                            document.querySelector('.task-11-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-11-claim-btn').disabled = true;
                            document.querySelector('.task-11-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-011-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t012() {
                window.location.href = "https://t.me/rocky_rabbit_bot/play?startapp=frId101471301";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task012' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t012);
                        
                        document.querySelector('.task-12-claim-btn').disabled = false;
                        document.querySelector('.task-12-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t012() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task012' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t012);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-12-perform-btn').disabled = false;
                            document.querySelector('.task-12-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-12-claim-btn').disabled = true;
                            document.querySelector('.task-12-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-012-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t013() {
                window.location.href = "https://t.me/cexio_tap_bot?start=1717078866843413";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task013' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t013);
                        
                        document.querySelector('.task-13-claim-btn').disabled = false;
                        document.querySelector('.task-13-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t013() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task013' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t013);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-13-perform-btn').disabled = false;
                            document.querySelector('.task-13-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-13-claim-btn').disabled = true;
                            document.querySelector('.task-13-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-013-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t014() {
                window.location.href = "https://t.me/dogshouse_bot/join?startapp=9hVrn5GcRSuurneTEMcgVQ";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task014' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t014);
                        
                        document.querySelector('.task-14-claim-btn').disabled = false;
                        document.querySelector('.task-14-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t014() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task014' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t014);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-14-perform-btn').disabled = false;
                            document.querySelector('.task-14-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-14-claim-btn').disabled = true;
                            document.querySelector('.task-14-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-014-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t015() {
                window.location.href = "https://t.me/vertus_app_bot/app?startapp=101471301";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task015' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t015);
                        
                        document.querySelector('.task-15-claim-btn').disabled = false;
                        document.querySelector('.task-15-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t015() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task015' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t015);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-15-perform-btn').disabled = false;
                            document.querySelector('.task-15-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-15-claim-btn').disabled = true;
                            document.querySelector('.task-15-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-015-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t016() {
                window.location.href = "";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task016' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t016);
                        
                        document.querySelector('.task-16-claim-btn').disabled = false;
                        document.querySelector('.task-16-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t016() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task016' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t016);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-16-perform-btn').disabled = false;
                            document.querySelector('.task-16-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-16-claim-btn').disabled = true;
                            document.querySelector('.task-16-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-016-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t017() {
                window.location.href = "https://t.me/wcoin_tapbot?start=MTAxNDcxMzAx";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task017' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t017);
                        
                        document.querySelector('.task-17-claim-btn').disabled = false;
                        document.querySelector('.task-17-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t017() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task017' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t017);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-17-perform-btn').disabled = false;
                            document.querySelector('.task-17-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-17-claim-btn').disabled = true;
                            document.querySelector('.task-17-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-017-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t018() {
                window.location.href = "https://t.me/herewalletbot/app?startapp=6354448";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task018' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t018);
                        
                        document.querySelector('.task-18-claim-btn').disabled = false;
                        document.querySelector('.task-18-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t018() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task018' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t018);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-18-perform-btn').disabled = false;
                            document.querySelector('.task-18-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-18-claim-btn').disabled = true;
                            document.querySelector('.task-18-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-018-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t019() {
                window.location.href = "https://t.me/MMproBump_bot?start=ref_101471301";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task019' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t019);
                        
                        document.querySelector('.task-19-claim-btn').disabled = false;
                        document.querySelector('.task-19-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t019() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task019' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t019);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-19-perform-btn').disabled = false;
                            document.querySelector('.task-19-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-19-claim-btn').disabled = true;
                            document.querySelector('.task-19-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-019-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
            function perform_t020() {
                window.location.href = "https://t.me/boom?start=DYZVxTA78ctbao7XeSfQFV";
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'performajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task020' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t020);
                        
                        document.querySelector('.task-20-claim-btn').disabled = false;
                        document.querySelector('.task-20-claim-btn').style.backgroundColor = "#FF8800";
                    }
                });
            }
            function claim_t020() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'claimajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?>, taskID: 'Task020' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var newBalanceAfterTask = Number(response.userBalanceAfterTask);
                        var userTaskStatus = Number(response.t020);
                        
                        if (userTaskStatus < 4) {
                            document.querySelector('.task-20-perform-btn').disabled = false;
                            document.querySelector('.task-20-perform-btn').style.backgroundColor = "#FF8800";
                            document.querySelector('.task-20-claim-btn').disabled = true;
                            document.querySelector('.task-20-claim-btn').style.backgroundColor = "#202B40";
                            document.querySelector('.card-task-fail-message').style.display = 'flex';
                        } else {
                            document.querySelector('.task-020-frame').style.display = 'none';
                            document.querySelector('.card-task-success-message').style.display = 'flex';
                            document.getElementById('balance-value-claim').innerHTML = newBalanceAfterTask.toLocaleString();
                        }
                    }
                });
            }
            
        </script>

        
        <script>
            function closetaskSuccessMsg() {
                document.querySelector('.card-task-success-message').style.display = 'none';        
            }
            function closetaskFailMsg() {
                document.querySelector('.card-task-fail-message').style.display = 'none';        
            }
        </script>
        
            
        <script> /* Claim */
        
            function tap() {
                
                $('.tap-claim-amount').show();
                $('.filler').show();
                $('.circle-tap-effect').show();
                setTimeout(function() {
                    $('.circle-tap-effect').hide();
                    $('.tap-claim-amount').hide();
                }, 2000);
                $('.coin-cover').show();
                setTimeout(function() {
                    $('.coin-cover').hide();
                    $('.filler').hide();
                }, 5000);
                var weeImg = document.querySelector('.weecoin-image');
                var width;
                var rotateDeg;
                rotateDeg = 1;
                x = setInterval(function() {
                    weeImg.style.transform = 'rotate(' + rotateDeg + 'deg)';
                    if(rotateDeg == 360) {
                        clearInterval(x);
                    }
                    rotateDeg += 1;
                }, 1);

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'tapajax.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> },
                    success: function(response){
                        var response = JSON.parse(response);
                        var newBalance = Number(response.userBalance);
                        var userDayTap = Number(response.userdayTaps);
                        var dayTapLimit = "/130";
                        document.getElementById('balance-value-claim').innerHTML = newBalance.toLocaleString();
                        document.querySelector('.user-touch-amount').innerHTML = userDayTap.toLocaleString() + dayTapLimit;

                        if (Number(userDayTap) <= 0) {
                            $('.filler').hide();
                            setTimeout(function() {
                                $('.coin-inactive').show();
                                document.querySelector('.card-touch-finished').style.display = "flex";
                            }, 1800);
                        }
                        
                    }
                });
            }
            
        </script>
        

        <script>
            function refreshPage() {
                location.reload();
            };
        </script>


        <script>
            function tgEnableDisable(tgtxtweecode) {

                <?php $user = $db->table('USERS')->where('telegramID', $chat_id)->first(); ?>;
                var user_tg_verified = <?php echo($user['tCardDone']); ?>;
                var tgBtnSubmit = document.querySelector('.tg-weecode-button');

                if (user_tg_verified == 1) {
                    tgBtnSubmit.disabled = true;
                    tgBtnSubmit.style.backgroundColor = "#ccc";
                } else {
                    tgBtnSubmit.disabled = false;
                    tgBtnSubmit.style.backgroundColor = "#FF8300";
                }
            };
        </script>


        <script>
            function tyEnableDisable(tytxtweecode) {

                <?php $user = $db->table('USERS')->where('telegramID', $chat_id)->first(); ?>;
                var user_ty_verified = <?php echo($user['yCardDone']); ?>;
                var tyBtnSubmit = document.querySelector('.ty-weecode-button');

                if (user_ty_verified == 1) {
                    tyBtnSubmit.disabled = true;
                    tyBtnSubmit.style.backgroundColor = "#ccc";
                } else {
                    tyBtnSubmit.disabled = false;
                    tyBtnSubmit.style.backgroundColor = "#FF8300";
                }
            };
        </script>

        
        <script>
            function txEnableDisable(txtxtweecode) {

                <?php $user = $db->table('USERS')->where('telegramID', $chat_id)->first(); ?>;
                var user_tx_verified = <?php echo($user['xCardDone']); ?>;
                var txBtnSubmit = document.querySelector('.tx-weecode-button');

                if (user_tx_verified == 1) {
                    txBtnSubmit.disabled = true;
                    txBtnSubmit.style.backgroundColor = "#ccc";
                } else {
                    txBtnSubmit.disabled = false;
                    txBtnSubmit.style.backgroundColor = "#FF8300";
                }
            };
        </script>


        <script> /* TG VERIFY */
            function tgVerify() {

                const user_chat_id = <?php echo($user['telegramID']); ?>;
                const tgWeecode = document.querySelector('.tg-weecode-input').value;

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'tgVerifyajax.php',
                    data: { user_chat_id, tgWeecode },
                    success: function(response){
                        
                        var response = JSON.parse(response);
                        var tgBtnSubmit = document.querySelector('.tg-weecode-button');

                        if (response.status == 1) {
                            var userNewBalance = Number(response.userBalance);
                            document.querySelector('.balance-value').innerHTML = userNewBalance.toLocaleString();
                            tgBtnSubmit.disabled = true;
                            tgBtnSubmit.style.backgroundColor = "#ccc";
                            document.querySelector('.card-success-message').style.display = 'flex';
                        } else {
                            document.querySelector('.card-fail-message').style.display = 'flex';
                        }
                        
                    }
                        
                });

            }
        </script>

        
        <script> /* TX VERIFY */
            function txVerify() {

                const user_chat_id = <?php echo($user['telegramID']); ?>;
                const txWeecode = document.querySelector('.tx-weecode-input').value;

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'txVerifyajax.php',
                    data: { user_chat_id, txWeecode },
                    success: function(response){
                        
                        var response = JSON.parse(response);
                        var txBtnSubmit = document.querySelector('.tx-weecode-button');

                        if (response.status == 1) {
                            var userNewBalance = Number(response.userBalance);
                            document.querySelector('.balance-value').innerHTML = userNewBalance.toLocaleString();
                            txBtnSubmit.disabled = true;
                            txBtnSubmit.style.backgroundColor = "#ccc";
                            document.querySelector('.card-success-message').style.display = 'flex';
                            
                        } else {
                            document.querySelector('.card-fail-message').style.display = 'flex';
                        }
                        
                    }
                        
                });

            }
        </script>


        <script> /* TY VERIFY */
            function tyVerify() {
                

                const user_chat_id = <?php echo($user['telegramID']); ?>;
                const tyWeecode = document.querySelector('.ty-weecode-input').value;

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'tyVerifyajax.php',
                    data: { user_chat_id, tyWeecode },
                    success: function(response){
                        
                        var response = JSON.parse(response);
                        var tyBtnSubmit = document.querySelector('.ty-weecode-button');

                        if (response.status == 1) {
                            var userNewBalance = Number(response.userBalance);
                            document.querySelector('.balance-value').innerHTML = userNewBalance.toLocaleString();
                            tyBtnSubmit.disabled = true;
                            tyBtnSubmit.style.backgroundColor = "#ccc";
                            document.querySelector('.card-success-message').style.display = 'flex';
                            
                        } else {
                            document.querySelector('.card-fail-message').style.display = 'flex';
                        }
                
                    }
                        
                });

            }
        </script>

<!--
        <script> /* Claim timer */
        
            var h = document.getElementById("hours");
            var m = document.getElementById("minutes");
            var s = document.getElementById("seconds");
            
            const userClaimTime = new Date('.........................................').getTime();

            const msInSecond = 1000;
            const msInMinute = msInSecond * 60;
            const msInHour = msInMinute * 60;
            const msInDay = msInHour * 24;

            var x = setInterval(() => {
                const distance = userClaimTime - new Date().getTime();
                const remainDays = Math.floor(distance/msInDay);
                const remainHours = Math.floor(distance % msInDay / msInHour);
                const remainMinutes = Math.floor(distance % msInHour / msInMinute);
                const remainSeconds = Math.floor(distance % msInMinute / msInSecond);

                if (distance > 0) {
                    if (remainHours < 10) {
                        h.innerHTML = "0" + remainHours;
                    } else {
                        h.innerHTML = remainHours;
                    }
                    if (remainMinutes < 10) {
                        m.innerHTML = "0" + remainMinutes;
                    } else {
                        m.innerHTML = remainMinutes;
                    }
                    if (remainSeconds < 10) {
                        s.innerHTML = "0" + remainSeconds;
                    } else {
                        s.innerHTML = remainSeconds;
                    }
                } else {
                    document.getElementById("timer").style.backgroundColor ="#fff";
                    h.innerHTML = "00";
                    m.innerHTML = "00";
                    s.innerHTML = "00";
                    clearInterval(x);
                }
            }, 1000);

        </script>
-->        
        <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

        <script>
            $(window).on("load", function() {
                $(".loading").fadeOut(200, function() {
                    $(".content").fadeIn(200);
                });
            });
        </script>

    </body>

</html>
