<?php

require_once('config.php');
require_once('telegram_json.php');
require_once('Classes/DBConnection.php');
require_once('Classes/DB.php');
require_once('Classes/TelegramService.php');
require_once('Classes/Telegram.php');
require_once('helper.php');
require_once('default_keyboard.php');

use Classes\DB;
use Classes\Telegram;


global $db;
global $telegram;
global $user;
global $base;
global $deposit_hash;
global $double_hash;
global $double_address;


$db = new DB();
$telegram = new Telegram();
$double_hash = 0;
$double_address = 0;


$base = $db->table('BASEDATA')->where('id', 1)->first();

$user = $db->table('USERS')->where('UsTgId', $chat_id)->first();

$deposit_hash = $db->table('HASHES')->where('UsTgId', $chat_id)->where('runDay', $base['runDay'])->first();


if (empty($user)) {
    
    $db->table('USERS')->insert(['UsTgId'], [$chat_id]);
    $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
}

if (empty($deposit_hash) && !$user['isAdmin']) {
    
    $db->table('HASHES')->insert(['runDay', 'UsTgId'], [$base['runDay'], $user['UsTgId']]);
    $deposit_hash = $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->first();
}


/*
if ($user['UsTgId'] != '101471301') {
        
    $text_send = '⏰ در حال به‌روزرسانی ربات هستیم. این کار ممکن است چند ساعت زمان ببرید.' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;
    
}
*/

if (str_contains($text, '/start')) {

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);

    if (str_contains($text, '/start ')) {
        
        $refer = str_replace("/start ","", $text);
        $before_referred = $db->table('REFERRALS')->where('referral', $chat_id)->first();
        if (empty($before_referred) && $refer != $chat_id) {
            
            $db->table('REFERRALS')->insert(['referrer', 'referral'], [$refer, $chat_id]);
            $userRefsNum = $db->table('USERS')->where('UsTgId', $refer)->first();
            $db->table('USERS')->where('UsTgId', $refer)->update(['RefsNum'], [$userRefsNum['RefsNum'] + 1]);
            
        }

    } else {
        $before_referred = $db->table('REFERRALS')->where('referral', $chat_id)->first();
        if (empty($before_referred)) {
            $db->table('REFERRALS')->insert(['referrer', 'referral'], ['0000000000', $chat_id]);
        }
    }

    $text_send = '❇️ به ربات استارک خوش آمدید.' . "\n\n";
    $text_send .= '   ➖ ایردراپ تتری رایگان' . "\n";
    $text_send .= '   ➖ تامین سرمایه اولیه' . "\n";
    $text_send .= '   ➖ سیگنال‌های ویـــژه' . "\n";
    $text_send .= '   ➖ فرصت‌های اقتصادی' . "\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;
    
}


//    $telegram->setText($content)->setReplyMarkup($mainKeyboard)->sendMessage();


/*
if ($text == '🎟 کپـی‌تـریـدینـگ 🎟') {

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);
//
    $text_send = '1️⃣ مرحله 1' . "\n\n";
    $text_send .= 'ویدیوی آموزشی ثبت‌نام در صرافی بینگ‌اکس + فعال‌سازی گوگل آتنتیکیتور' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->setFileId('BAACAgQAAxkBAAIFrWYT_-0rqD-8CBrlNxzRbKbYScTRAAIdEAACbRqhUMDibEW0s7ixNAQ', 'video')->sendFile();

    $text_send = '2️⃣ مرحله 2' . "\n\n";
    $text_send .= 'نحوه تبدیل ریال به تتر و بالعکس از طریق صرافی ایرانی نوبیتکس' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->setFileId('BAACAgQAAxkBAAIFq2YT8ugU7F2e32B_hhVawwEtrDhqAAIUEAACbRqhUMGdMGham59ANAQ', 'video')->sendFile();

    $text_send = '3️⃣ مرحله 3' . "\n\n";
    $text_send .= 'نحوه واریز و برداشت تتر در بینگ‌اکس' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->setFileId('BAACAgQAAxkBAAIFqGYT6Ko9zbLjghKpewxtoewXOcJ1AAIKEAACbRqhUKvRUQratSSBNAQ', 'video')->sendFile();

    $text_send = '❇️ کپی‌تریدینگ رایگان' . "\n\n";
    $text_send .= '➖ ابتدا ویدیوهای آموزشی فوق را با دقت نگاه کرده و مراحل گفته‌شده را انجام دهید. سپس براساس توضیحاتی که در پایین بیان گردیده عمل نمایید.' . "\n\n";
    $text_send .= '➖ میانگین بازه سوددهی ماهانه کپی‌تریدینگ بین 20% تا 80% است اما می‌تواند بیشتر از 80% نیز باشد. تیم استارک، تریدرهای حرفه‌ای را به‌نحوی انتخاب و رصد می‌کند که سودآوری ماهانه کمتر از 20% نشود. برای کپی‌تریدینگ حداقل 100 تتر سرمایه لازم است اما توصیه می‌شود جهت سودآوری مناسب، حداقل 500 تتر داشته باشید.' . "\n\n";
    $text_send .= '➖ اگر متقاضی کپی‌تریدینگ رایگان هستید، عکس صفحه رفرال حساب بینگ‌اکس خود را (طبق ویدیوی آخر) به همراه شناسه ربات به آیدی زیر ارسال نمایید تا کپی‌تریدینگ برای شما فعال شود.' . "\n\n";
    $text_send .= '@Otteh' . ' | ' . '@Otteh' . "\n\n";
    $text_send .= '➖ پس از فعال‌سازی، لیست تریدرهای حرفه‌ای جهت کپی‌کردن برای شما ارسال می‌شود. هر زمان لیست جدیدی برایتان ارسال شد، کپی را طبق لیست جدید به‌روزرسانی کنید.' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;

    
} else if ($text == '🔘 کپی‌تـریدیـنـگ 🔘' || $text == '🔘 فارکـس‌پـلاس 🔘' || $text == '🔘 سیگنال ویــژه 🔘' || $text == '🔘 ســــود ثـابـت 🔘') {

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);

    $text_send = '❇️ تــــوجـــه' . "\n\n";
    $text_send .= 'این آیتم به‌زودی روشن (فعال) می‌شود. تا آن موقع از درآمد رایگان لذت ببرید و دوستان خود را به ربات دعوت کنید.' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;
*/
    
if ($text == '🎟 درآمــــــد رایـــگـان 🎟') {

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);

    if ($user['AirAct'] == 1) {

        $text_send = '❇️ درآمــد رایــگان' . "\n\n";
        $text_send .= 'با زدن دکمه "شانس امروز من"، یک عدد تصادفی بین 100 تا 999 تولید شده و مطابق جدول فوق برنده جایزه دلاری می‌شوید.' . "\n\n";
        $text_send .= '🔴 شرایط ضروری' . "\n";
        $text_send .= '➖ دریافت جوایز منوط به عضویت دائمی در کانال @drgbdi و لایک‌کردن پست‌هایی است که تازه در کانال گذاشته می‌شوند (👍).' . "\n";
        $text_send .= '➖ هر کاربر، روزانه یک شانس دارد. برای افزایش تعداد دفعات شانس روزانه به دکمه "افزایش شانس" مراجعه نمایید.' . "\n";
        $text_send .= '➖ به محض اینکه موجودی شما به 100 تتر برسد، بطور خودکار به کیف پولتان واریز شده و درآمد شما از نو شروع می‌گردد.' . "\n";
        $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->setFileId('AgACAgQAAxkBAAEBn_lmNMJQ5qP2SSRVQwvWEw37FigKDAACe8IxGy-DoVEDgSzsQUANpAEAAwIAA3gAAzQE', 'photo')->sendFile();

    } else {

        $text_send = '⛔️ ابتدا باید در کانال دکتر قبادی عضو شوید. لینک عضویت در کانال :' . "\n\n";
        $text_send .= 'https://t.me/drgbdi' . "\n";
        $text_send .= 'https://t.me/drgbdi' . "\n";
        $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirAct'], [1]);
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();

    }
    return;
    
    
} else if ($text == '🔔 شانس امروز من 🔔') {

    if ($user['AirUSD'] < 10) {
        $randnumber = rand(996, 996);
    } else if ($user['AirUSD'] >= 10 && $user['AirUSD'] < 80) {
        $randnumber = rand(501, 995);
    } else if ($user['AirUSD'] >= 80 && $user['AirUSD'] < 90) {
        $randnumber = rand(301, 500);
    } else if ($user['AirUSD'] >= 90 && $user['AirUSD'] < 95) {
        $randnumber = rand(201, 300);
    } else if ($user['AirUSD'] >= 95 && $user['AirUSD'] < 98) {
        $randnumber = rand(151, 200);
    } else {
        $randnumber = rand(100, 150);
    }
    
    if ($user['AirNum'] > 0) {
        
        if ($randnumber == 999) {
            $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirUSD', 'AirNum'], [$user['AirUSD'] + 80.00, $user['AirNum'] - 1]);
            $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
            $text_send = '🔢 عدد تصادفی : ' . $randnumber . "\n\n";
            $text_send .= '✅ شما برنده';
            $text_send .= ' 80.00 ';
            $text_send .= 'تتر شدید.' . "\n\n";
            $text_send .= '✅ موجودی : ' . $user['AirUSD'] .  ' تتر' . "\n\n";
            $text_send .= '🔄 تعداد شانس باقیمانده : ' . $user['AirNum'];
            $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();

        } else if ($randnumber == 998) {
            $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirUSD', 'AirNum'], [$user['AirUSD'] + 50.00, $user['AirNum'] - 1]);
            $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
            $text_send = '🔢 عدد تصادفی : ' . $randnumber . "\n\n";
            $text_send .= '✅ شما برنده';
            $text_send .= ' 50.00 ';
            $text_send .= 'تتر شدید.' . "\n\n";
            $text_send .= '✅ موجودی : ' . $user['AirUSD'] .  ' تتر' . "\n\n";
            $text_send .= '🔄 تعداد شانس باقیمانده : ' . $user['AirNum'];
            $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();

        } else if ($randnumber == 997) {
            $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirUSD', 'AirNum'], [$user['AirUSD'] + 30.00, $user['AirNum'] - 1]);
            $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
            $text_send = '🔢 عدد تصادفی : ' . $randnumber . "\n\n";
            $text_send .= '✅ شما برنده';
            $text_send .= ' 30.00 ';
            $text_send .= 'تتر شدید.' . "\n\n";
            $text_send .= '✅ موجودی : ' . $user['AirUSD'] .  ' تتر' . "\n\n";
            $text_send .= '🔄 تعداد شانس باقیمانده : ' . $user['AirNum'];
            $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();

        } else if ($randnumber == 996) {
            $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirUSD', 'AirNum'], [$user['AirUSD'] + 10.00, $user['AirNum'] - 1]);
            $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
            $text_send = '🔢 عدد تصادفی : ' . $randnumber . "\n\n";
            $text_send .= '✅ شما برنده';
            $text_send .= ' 10.00 ';
            $text_send .= 'تتر شدید.' . "\n\n";
            $text_send .= '✅ موجودی : ' . $user['AirUSD'] .  ' تتر' . "\n\n";
            $text_send .= '🔄 تعداد شانس باقیمانده : ' . $user['AirNum'];
            $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();

        } else if ($randnumber >= 501 && $randnumber <= 995) {
            $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirUSD', 'AirNum'], [$user['AirUSD'] + 1.00, $user['AirNum'] - 1]);
            $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
            $text_send = '🔢 عدد تصادفی : ' . $randnumber . "\n\n";
            $text_send .= '✅ شما برنده';
            $text_send .= ' 1.00 ';
            $text_send .= 'تتر شدید.' . "\n\n";
            $text_send .= '✅ موجودی : ' . $user['AirUSD'] .  ' تتر' . "\n\n";
            $text_send .= '🔄 تعداد شانس باقیمانده : ' . $user['AirNum'];
            $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();

        } else if ($randnumber >= 301 && $randnumber <= 500) {
            $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirUSD', 'AirNum'], [$user['AirUSD'] + 0.1, $user['AirNum'] - 1]);
            $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
            $text_send = '🔢 عدد تصادفی : ' . $randnumber . "\n\n";
            $text_send .= '✅ شما برنده';
            $text_send .= ' 0.1 ';
            $text_send .= 'تتر شدید.' . "\n\n";
            $text_send .= '✅ موجودی : ' . $user['AirUSD'] .  ' تتر' . "\n\n";
            $text_send .= '🔄 تعداد شانس باقیمانده : ' . $user['AirNum'];
            $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();

        } else if ($randnumber >= 201 && $randnumber <= 300) {
            $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirUSD', 'AirNum'], [$user['AirUSD'] + 0.01, $user['AirNum'] - 1]);
            $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
            $text_send = '🔢 عدد تصادفی : ' . $randnumber . "\n\n";
            $text_send .= '✅ شما برنده';
            $text_send .= ' 0.01 ';
            $text_send .= 'تتر شدید.' . "\n\n";
            $text_send .= '✅ موجودی : ' . $user['AirUSD'] .  ' تتر' . "\n\n";
            $text_send .= '🔄 تعداد شانس باقیمانده : ' . $user['AirNum'];
            $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();

        } else if ($randnumber >= 151 && $randnumber <= 200) {
            $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirUSD', 'AirNum'], [$user['AirUSD'] + 0.005, $user['AirNum'] - 1]);
            $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
            $text_send = '🔢 عدد تصادفی : ' . $randnumber . "\n\n";
            $text_send .= '✅ شما برنده';
            $text_send .= ' 0.005 ';
            $text_send .= 'تتر شدید.' . "\n\n";
            $text_send .= '✅ موجودی : ' . $user['AirUSD'] .  ' تتر' . "\n\n";
            $text_send .= '🔄 تعداد شانس باقیمانده : ' . $user['AirNum'];
            $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();

        } else if ($randnumber >= 100 && $randnumber <= 150) {
            $db->table('USERS')->where('UsTgId', $chat_id)->update(['AirUSD', 'AirNum'], [$user['AirUSD'] + 0.0002, $user['AirNum'] - 1]);
            $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
            $text_send = '🔢 عدد تصادفی : ' . $randnumber . "\n\n";
            $text_send .= '✅ شما برنده';
            $text_send .= ' 0.0002 ';
            $text_send .= 'تتر شدید.' . "\n\n";
            $text_send .= '✅ موجودی : ' . $user['AirUSD'] .  ' تتر' . "\n\n";
            $text_send .= '🔄 تعداد شانس باقیمانده : ' . $user['AirNum'];
            $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();

        }

    } else {
        $text_send = '🔴 تعداد دفعات شانس شما به اتمام رسیده است. جهت افزایش آن به قسمت دکمه "افزایش شانس" بروید.';
        $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();
    }
    return;
    
    
} else if ($text == '☑️ افزایش شانس ☑️') {

    $text_send = '❇️ افزایش تعداد شانس روزانه' . "\n\n";
    $text_send .= 'راه افزایش تعداد شانس روزانه، دعوت از دوستان با استفاده از لینک رفرال (زیرمجموعه) خودتان است. تعداد شانس شما به شرح زیر افزایش می‌یابد:' . "\n\n";
    $text_send .= '➖ بیش از 3 رفرال : 2 شانس اضافه' . "\n";
    $text_send .= '➖ بیش از 8 رفرال : 5 شانس اضافه' . "\n";
    $text_send .= '➖ بیش از 24 رفرال : 8 شانس اضافه' . "\n\n";
    $text_send .= '🌐 لینـک رفــرال شــما' . "\n";
    $text_send .= 'لینک زیر را برای دوستان خود بفرستید تا آنها رفرال (یا زیرمجموعه) شما شوند. بدین‌وسیله تعداد شانس روزانه شما افزایش می‌یابد.' . "\n\n";
    $text_send .= 'https://t.me/StarkIncBot?start=' . $chat_id . "\n\n";
    $text_send .= '🔴 نباید اکانت‌های فیک، اکانت‌های دیگر خودتان، اکانت‌های همسر یا فرزندان را برای خود رفرال کنید. ربات از روی اینترنت یکسان و آی‌پی، اکانت‌های مرتبط را شناسایی کرده و مراحل بعدی ایردراپ را برای آنها سخت‌تر می‌کند.' . "\n";
    $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();
    return;
    
    
} else if ($text == '☑️ سـایـر درآمــدها ☑️') {

    $text_send = '❇️ سایر درآمدهای رایگان' . "\n\n";
    $text_send .= 'هر منبع درآمدی که رایگان و معتبر بوده و وقت‌گیر و اذیت‌کن نباشد، در کانال زیر معرفی و آموزش داده می‌شود.' . "\n\n";
    $text_send .= 'https://t.me/drgbdi' . "\n";
    $text_send .= 'https://t.me/drgbdi' . "\n";
    $telegram->setText($text_send)->setReplyMarkup($freeIncomeKeyboard)->sendMessage();
    return;
    
    
} else if ($text == '🎟 بخــت آزمــــــایــی 🎟') {

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);

    $text_send = '❇️ بخت‌آزمایی' . "\n\n";
    $text_send .= 'بخت‌آزمایی، یک روش گروهی جهت تامین سرمایه برای همدیگر است به نحوی که پول‌های خرد شرکت‌کنندگان جمع شده و هر بار به یک یا چند نفر پرداخت می‌گردد. برای شرکت در هر سری از بخت‌آزمایی باید نسبت به خریداری بلیت اقدام نمایید:' . "\n\n";
    $text_send .= '   ➖ 10 بلیت 2 تتر (5 بلیت جایزه)' . "\n";
    $text_send .= '   ➖ 30 بلیت 4 تتر (15 بلیت جایزه)' . "\n";
    $text_send .= '   ➖ 90 بلیت 8 تتر (30 بلیت جایزه)' . "\n\n";
    $text_send .= '1️⃣ هر زمان که مجموع پول‌های جمع‌شده به حدود 400 تتر برسد، یک قرعه‌کشی اتوماتیک انجام می‌شود و کل پول به یکنفر پرداخت می‌شود. برنده اجازه دارد در سری‌های بعدی بخت‌آزمایی نیز شرکت نماید. چنانچه پول بیشتری قبل از قرعه‌کشی جمع شود، بجای یک برنده، چند برنده خواهیم داشت.' . "\n\n";
    $text_send .= '2️⃣ پس از هر قرعه‌کشی و تعیین برنده، تمامی بلیت‌های آن سری از بخت‌آزمایی برای برنده سوزانده می‌شود اما برای مابقی شرکت‌کنندگان، بلیت‌های جایزه حفظ می‌گردند تا شانس آنها را برای سری‌های بعدی افزایش دهند.' . "\n\n";
    $text_send .= '3️⃣ با توجه به اینکه کل پول شرکت‌کنندگان به برنده‌(ها) پرداخت می‌گردد لذا شرکت‌کننده نمی‌تواند در روزهای آتی ادعا نماید که از ربات طلبکار است!' . "\n\n";
    $text_send .= '4️⃣ بلیت‌های جایزه تا روزی که شخص برنده شود باقی می‌مانند. علاوه بر آن، هر بار که وی در بخت‌آزمایی شرکت می‌کند به تعداد بلیت‌های جایزه‌اش اضافه می‌شود تا شانس او برای برنده‌شدن در سری‌های بعدی را افزایش دهند. بلیت‌های جایزه هیچ تفاوتی با بلیت‌های خریداری‌شده ندارند اما چنانچه کاربر در سری‌های بعدی شرکت نکند، در قرعه‌کشی آن سری لحاظ نمی‌شود حتی اگر بلیت جایزه داشته باشد.' . "\n\n";
    $text_send .= '5️⃣ هر زمان که شخصی در بخت‌آزمایی برنده می‌شود، همان روز بطور خودکار پول به کیف پولش واریز می‌گردد پس حتماً آدرس کیف پول BEP20 خود را در ربات ثبت نمایید وگرنه نمی‌توانید پولی که برنده شدید را دریافت کنید.' . "\n\n";
    $text_send .= '' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();

    if ($user['LotAct'] == 1) {

        $text_send = '🔔 شما در این سری از بخت‌آزمایی شرکت کرده‌اید اما هنوز قرعه‌کشی انجام نشده است. لطفاً منتظر قرعه‌کشی بمانید. ضمناً در هر لحظه می‌توانید وضعیت خود را از منوی "وضعیت" چک کنید.';
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            
    } else {

        $text_send = '⚖️ چنانچه توضیحات فوق را خوانده‌ و کاملاً متوجه شده‌اید، حال یکی از دکمه‌های زیر را به دلخواه انتخاب و در این سری از بخت‌آزمایی شرکت نمایید.' . "\n\n";
        $text_send .= 'چند بلیت برای شرکت در این سری از بخت‌آزمایی می‌خواهید؟ 👇';
        $telegram->setText($text_send)->setReplyMarkup($lottoryKeyboard)->sendMessage();
        
    }    
    return;
    
    
} else if ($text == '🎟 10 Tickets ($2.0) 🎟') {

    if ($user['Balance'] >= 2) {
        
        $db->table('USERS')->where('UsTgId', $chat_id)->update(['Balance', 'LotAct', 'GiftTickets', 'MainTickets'], [$user['Balance']-2, 1, $user['GiftTickets']+5, 10]);
        $db->table('BASEDATA')->where('id', 1)->update(['totTIKs', 'totUSD'], [$base['totTIKs'] + 15, $base['totUSD'] + 2]);
        $text_send = '✅ شما با موفقیت در سری ';
        $text_send .= $base['LotSery'];
        $text_send .= ' بخت‌آزمایی شرکت و تعداد 10 بلیت خریداری کردید که به‌همراه 5 بلیت جایزه (جمعاً 15 بلیت) برایتان ثبت شد. اکنون می‌توانید وضعیت خود را از منوی "وضعیت" چک نمایید.';
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        
    } else {
        
        $text_send = '⛔️ موجودی کیف پول شما کافی نیست. ابتدا کیف پول خود را با استفاده از منوی "کیف پول" شارژ نمایید.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        
    }
    return;
    
    
} else if ($text == '🎟 30 Tickets ($4.0) 🎟') {

    if ($user['Balance'] >= 4) {
        
        $db->table('USERS')->where('UsTgId', $chat_id)->update(['Balance', 'LotAct', 'GiftTickets', 'MainTickets'], [$user['Balance']-4, 1, $user['GiftTickets']+15, 30]);
        $db->table('BASEDATA')->where('id', 1)->update(['totTIKs', 'totUSD'], [$base['totTIKs'] + 45, $base['totUSD'] + 4]);
        $text_send = '✅ شما با موفقیت در سری ';
        $text_send .= $base['LotSery'];
        $text_send .= ' بخت‌آزمایی شرکت و تعداد 30 بلیت خریداری کردید که به‌همراه 15 بلیت جایزه (جمعاً 45 بلیت) برایتان ثبت شد. اکنون می‌توانید وضعیت خود را از منوی "وضعیت" چک نمایید.';
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        
    } else {
        
        $text_send = '⛔️ موجودی کیف پول شما کافی نیست. ابتدا کیف پول خود را با استفاده از منوی "کیف پول" شارژ نمایید.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        
    }
    return;
    
    
} else if ($text == '🎟 90 Tickets ($8.0) 🎟') {

    if ($user['Balance'] >= 8) {
        
        $db->table('USERS')->where('UsTgId', $chat_id)->update(['Balance', 'LotAct', 'GiftTickets', 'MainTickets'], [$user['Balance']-8, 1, $user['GiftTickets']+45, 90]);
        $db->table('BASEDATA')->where('id', 1)->update(['totTIKs', 'totUSD'], [$base['totTIKs'] + 135, $base['totUSD'] + 8]);
        $text_send = '✅ شما با موفقیت در سری ';
        $text_send .= $base['LotSery'];
        $text_send .= ' بخت‌آزمایی شرکت و تعداد 90 بلیت خریداری کردید که به‌همراه 45 بلیت جایزه (جمعاً 135 بلیت) برایتان ثبت شد. اکنون می‌توانید وضعیت خود را از منوی "وضعیت" چک نمایید.';
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        
    } else {
        
        $text_send = '⛔️ موجودی کیف پول شما کافی نیست. ابتدا کیف پول خود را با استفاده از منوی "کیف پول" شارژ نمایید.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        
    }
    return;
    
    
} else if ($text == '➕ کیف پول ➕') {

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);

    $text_send = 'عملیات کیف پول' . "\n";
    $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();
    return;

    
} else if ($text == '☑️ آدرس کیف پول ☑️') {

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [1]);
    $text_send = '❇️ آدرس فعلی شما' . "\n";
    $text_send .= '   ➖ ';
    $text_send .= $user['WalAdd'] . "\n\n";
    $text_send .= 'آدرس BEP20 خود را به ربات ارسال نمایید تا ثبت یا ویرایش شود. آدرس‌های BEP20 با 0x شروع می‌شوند. مسئولیت ثبت آدرس اشتباه برعهده خودتان است.';
    $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();
    return;

    
} else if ($text == '☑️ شـارژ کیف پول ☑️') {

    if ($user['DayDep'] > 0) {
        
        $text_send = '⛔️ هر کاربر می‌تواند روزانه یکبار واریز انجام دهد. لطفاً تا روز بعد منتظر بمانید.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();
        return;
        
    } else {

        $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
        $db->table('HASHES')->where('UsTgId', $chat_id)->where('runDay', $base['runDay'])->update(['part_flag'], [1]);
    
        $text_send = '1️⃣ ابتدا مبلغ مورد نظرتان را بصورت تتر BEP20 به آدرس زیر در شبکه بایننس‌اسمارت (BSC) منتقل کنید:' . "\n\n";
        $text_send .= '0x' . $base['bAddress'] . "\n\n";
        $text_send .= '2️⃣ سپس هش تراکنش (TXID) را همین جا به ربات ارسال کرده و منتظر پیام ربات بمانید.' . "\n\n";
        $text_send .= '3️⃣ پس از ظاهرشدن پیام جهت تایید هش، دکمه "تایید هش" را بزنید و منتظر تاییدیه ربات باشید. تایید تراکنش ممکن است چند ثانیه زمان ببرد.' . "\n\n";
        $text_send .= '🔴 مسئولیت تراکنش‌های اشتباه برعهده کاربر بوده و پشتیبانی نمی‌تواند در این ارتباط کمکی نماید زیرا تراکنش‌های بلاکچین برگشت‌پذیر نیستند.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($hashKeyboard)->sendMessage();
        
    }
    return;

    
} else if ($text == '✅ تایید هش ✅') {
    
    $bsc_url = json_decode(file_get_contents('https://api.bscscan.com/api?module=proxy&action=eth_getTransactionReceipt&txhash=' . $deposit_hash['trans_hash']. '&apikey=' . BSC_API), true);

    if (hexdec($bsc_url['result']['status']) == 1) {
        
        if (str_contains($bsc_url['result']['logs']['0']['topics'][2], strtolower($base['bAddress']))) {
            
            if (str_contains($bsc_url['result']['to'], strtolower($base['cAddress']))) {
                    
                $deposit_amount = floor(hexdec($bsc_url['result']['logs']['0']['data'])/pow(10, 18));
                $user['Balance'] += $deposit_amount;
                $user['DayDep'] = $deposit_amount;
                $db->table('USERS')->where('UsTgId', $chat_id)->update(['Balance', 'DayDep'], [$user['Balance'], $user['DayDep']]);
                $db->table('HASHES')->where('UsTgId', $chat_id)->where('runDay', $base['runDay'])->update(['part_flag', 'hash_confirmed'], [0, 1]);

                $text_send = '✅ تراکنش شما تایید شد.' . "\n\n";
                $text_send .= 'مبلغ: ' . $deposit_amount . ' تتر';
                $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();

            } else {
                
                $db->table('HASHES')->where('UsTgId', $chat_id)->where('runDay', $base['runDay'])->update(['part_flag', 'hash_confirmed'], [0, 0]);
                $text_send = '⛔️ شما ارزی غیر از تتر BEP20 پرداخت کرده‌اید!';
                $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();
            }

        } else {
                
                $db->table('HASHES')->where('UsTgId', $chat_id)->where('runDay', $base['runDay'])->update(['part_flag', 'hash_confirmed'], [0, 0]);
                $text_send = '⛔️ شما مبلغ را به آدرس دیگری ارسال کرده‌اید!';
                $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();
        }
        
    } else {
        
        $db->table('HASHES')->where('UsTgId', $chat_id)->where('runDay', $base['runDay'])->update(['part_flag', 'trans_hash', 'hash_confirmed'], [0, NULL, 0]);
        $text_send = '⛔️ هش نامعتبر است!';
        $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();
    }
    return;
    
/*    
} else if ($text == '☑️ برداشت مبلغ ☑️') {

    $telegram->setText('Please read the "Investment Rules".')->setReplyMarkup($mainKeyboard)->sendMessage();

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 1, 0]);
    $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->first();

    if ($user['WMonth'] == 0) {
        $text_send = 'Total Investment: ' . $user['Balance'] . ' USDT' . "\n";
        $text_send .= 'Withdrawable Amount: ' . $user['Balance'] . ' USDT' . "\n\n";
        $text_send .= '1) Type the amount of withdrawal.' . "\n";
        $text_send .= '2) Send it to the bot.' . "\n";
        $text_send .= '3) Press the "Confirm" button.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($withdrawKeyboard)->sendMessage();
    } else {
        $text_send = '⛔️ You can make withdrawal requests only once a month. Please wait for the next month.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($investmentKeyboard)->sendMessage();
    }

    return;
    

} else if ($text == '✅ Confirm ✅') { // Withdraw

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->first();

    if ($user['WPend'] <= $user['Balance']) {
        $db->table('USERS')->where('UsTgId', $chat_id)->update(['Balance', 'WMonth'], [$user['Balance'] - $user['WPend'], 1]);
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = 'درخواست برداشت مبلغ ' . $user['WPend'] . ' تتر' . ' ثبت گردید ✅' . "\n\n";
            $text_send .= 'سرمایه باقیمانده: ' . $user['Balance'] - $user['WPend'] . ' تتر' . "\n\n";
            $text_send .= '🔵 درخواست اکنون در صف پردازش است. ممکن است چند ساعت تا چند روز طول بکشد تا پرداخت شود. درخواست‌ها به صورت خودکار انجام می‌شوند، بنابراین نیازی به ارسال پیام به پشتیبانی نیست.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        } else {
            $text_send = 'Withdraw of ' . $user['WPend'] . ' USDT' . ' is submitted ✅' . "\n\n";
            $text_send .= 'Remained Investment: ' . $user['Balance'] - $user['WPend'] . ' USDT' . "\n\n";
            $text_send .= '🔵 The request is now in the processing queue. It may take form a few hours to a few days to be paid. Requests are performed automatically, so there is no need to message the support.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
    } else {
        $db->table('USERS')->where('UsTgId', $chat_id)->update(['WPend'], [0]);
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = '⛔️ موجودی شما کافی نیست.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        } else {
            $text_send = '⛔️ Not enough balance.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
    }
    return;
*/
    
} else if ($text == '➕ وضعـیت ➕') {

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);

    $text_send = '❇️ وضعیت شما' . "\n\n";

    $text_send .= '   ▪️ شنــاســه : ';
    $text_send .= $user['UsTgId'] . "\n\n";

    $text_send .= '   ▪️ کیف پول اصلی' . "\n";
    $text_send .= '         ➖ موجودی : ';
    $text_send .= $user['Balance'] . ' تتر' . "\n\n";

    $text_send .= '   ▪️ کیف پول ایردراپ' . "\n";
    $text_send .= '         ➖ موجودی : ';
    $text_send .= $user['AirUSD'] . ' تتر' . "\n";
    $text_send .= '         ➖ تعداد رفرال : ';
    $text_send .= $user['RefsNum'] . "\n";
    $text_send .= '         ➖ شانس امروز : ';
    $text_send .= $user['AirNum'] . "\n\n";

/*
    $text_send .= '▪️ بخت‌آزمایی' . "\n";
    $text_send .= '         ➖ شماره سری برگزاری : ';
    $text_send .= $base['LotSery'] . "\n";
    $text_send .= '         ➖ مبلغ جمع‌شده تاکنون : ';
    $text_send .= $base['totUSD'] . ' تتر' . "\n";
    $text_send .= '         ➖ آیا شرکت کرده‌ام : ';
    $text_send .= $user['LotAct'] . "\n";
    $text_send .= '         ➖ تعداد بلیت من : ';
    $text_send .= $user['GiftTickets'] + $user['MainTickets'] . "\n";
    $text_send .= '         ➖ تعداد کل بلیت‌ها : ';
    $text_send .= $base['totTIKs'] - 1 . "\n";
    $text_send .= '         ➖ درصد شانس من : ';
    $text_send .= round(($user['GiftTickets'] + $user['MainTickets'])/$base['totTIKs']*100, 2) . '%' . "\n";

    $text_send .= '   ▪️ کپی‌تریدینگ (به‌زودی)' . "\n";
    $text_send .= '         ➖ فعال :  ';
    $text_send .= $user['CopAct'] . "\n\n";


    $text_send .= '   ▪️ فارکس‌پلاس (به‌زودی)' . "\n";
    $text_send .= '         ➖ فعال :  ';
    $text_send .= $user['FrxAct'] . "\n\n";

    $text_send .= '   ▪️ سیگنال ویژه (به‌زودی)' . "\n";
    $text_send .= '         ➖ فعال :  ';
    $text_send .= $user['SigAct'] . "\n";
    $text_send .= '         ➖ سیگنال دریافتی : ';
    $text_send .= $user['SigRvd'] . "\n\n";

    $text_send .= '   ▪️ سود ثابت ماهانه (به‌زودی)' . "\n";
    $text_send .= '         ➖ میزان سرمایه :  ';
    $text_send .= $user['Balance'];
    $text_send .= ' تتر' . "\n";
    $text_send .= '         ➖ روزهای سرمایه‌گذاری : ';
    $text_send .= $user['InvDay'] . "\n\n";
*/
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;


} else if ($text == '🔘 پـشتیبــانـی 🔘') {

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);

    $text_send = '❇️ فقط در خصوص مشکلات فنی ربات به پشتیبانی پیام دهید در غیر اینصورت به‌دلیل کثرت پیام‌ها پاسخ داده نمی‌شود.' . "\n\n";
    $text_send .= '🆔 https://t.me/+3bir0fgkxlwyMDdk' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;
    
    
} else if ($text == '🔘 بـازگـشت 🔘' || $text == '🔘 Cancel 🔘') { //main

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);
    $telegram->setText('بازگشت به صفحه اصلی')->setReplyMarkup($mainKeyboard)->sendMessage();
    return;
    
    
} else if ($text == '🔘 بـازگـشـت 🔘') { //wallet

    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);
    $telegram->setText('بازگشت')->setReplyMarkup($walletKeyboard)->sendMessage();
    return;
    
}


if ($user['WalFlag'] == 1 && $user['isAdmin'] == 0) {

    if (str_starts_with($text, '0x')) {

        if ($db->table('USERS')->where('UsTgId', $chat_id)->update(['WalAdd', 'WalFlag'], [$text, 0]) != false) {
            
            $text_send = '✅ آدرس کیف پول شما ذخیره شد.';
            $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();
            
        } else {
            
            $text_send = '⛔️ آدرس کیف پول تکراری است!';
            $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();

        }
                
    } else {
        
        $text_send = '⛔️ آدرس کیف پول اشتباه است!';
        $telegram->setText($text_send)->setReplyMarkup($walletKeyboard)->sendMessage();
        
    }
}


if ($deposit_hash['part_flag'] == 1 && !$user['isAdmin']) {

    if (str_starts_with($text, '0x')) {

        if ($db->table('HASHES')->where('UsTgId', $chat_id)->where('runDay', $base['runDay'])->update(['trans_hash'], [$text]) != false) {
            
            $text_send = '🔰 دکمه "تایید هش" را بزنید.';
            $telegram->setText($text_send)->setReplyMarkup($hashKeyboard)->sendMessage();
            
        } else {
            
            $text_send = '⛔️ هش تکراری است!';
            $telegram->setText($text_send)->setReplyMarkup($hashKeyboard)->sendMessage();
            
        }
                
    } else {
        
        $text_send = '⛔️ هش اشتباه است!';
        $telegram->setText($text_send)->setReplyMarkup($hashKeyboard)->sendMessage();
        
    }
}


// Admin Section


if ($user['isAdmin'] && $text == 'S') {
    $telegram->setText('Welcome admin 🌺')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
}
    
if ($user['isAdmin'] && $text == 'F') {
    $telegram->setText('Welcome Ali 🌺')->setReplyMarkup($mainKeyboard)->sendMessage();
}

if ($user['isAdmin']) {
    
    if ($text == 'Message On') {

        if ($base['sMsg'] == 0) {
            $db->table('BASEDATA')->where('id', 1)->update(['sMsg'], [1]);
            $telegram->setText('Message is ON')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
        } else {
            $db->table('BASEDATA')->where('id', 1)->update(['sMsg'], [0]);
            $telegram->setText('Message is OFF')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
        }


    } else if ($text == 'Statistics') {

        $text_send = '❇️ Statistics' . "\n\n";
        $text_send .= 'Tickets: ' . $base['totTIKs'] - 1 . "\n";
        $text_send .= 'Amount: ' . $base['totUSD'] . "\n";

        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard_admin)->sendMessage();


    } else if ($text == 'Send Message' && $base['sMsg'] == 1) {

        $text_send = '❇ توجه: چنانچه کاربر و رفرال‌های وی قوانین ربات را رعایت نکنند هیچ مبلغی به آنها پرداخت نخواهد شد. قوانین ربات یعنی اینکه باید در کانال زیر عضو شده و پست‌های آن را لایک کنید.' . "\n\n";
        $text_send .= "https://t.me/drgbdi" . "\n\n";

        $total_users = $db->table('USERS')->get('*');

        foreach($total_users as $tus) {
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage($tus['UsTgId']);
        }

        $db->table('BASEDATA')->where('id', 1)->update(['sMsg'], [0]);
        $telegram->setText('Done.')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
        return;
    }
//    $telegram->setText($content)->setReplyMarkup($mainKeyboard_admin)->sendMessage();
    
}
