<?php

require_once('config.php');
require_once('telegram_json.php');
require_once('Classes/DBConnection.php');
require_once('Classes/DB.php');
require_once('Classes/TelegramService.php');
require_once('Classes/Telegram.php');
require_once('helper.php');
require_once('default_keyboard.php');

use Classes\DB;
use Classes\Telegram;


global $db;
global $telegram;
global $user;
global $base;


$db = new DB();
$telegram = new Telegram();


$base = $db->table('BASEDATA')->where('id', 1)->first();

/*

$user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

if (empty($user)) {
    
    $db->table('USERS')->insert(['user_tel_id'], [$chat_id]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
}
*/


// Begin of API Definition

function doRequest($protocol, $host, $api, $method, $API_KEY, $API_SECRET, $payload)
{
    $timestamp = round(microtime(true) * 1000);
    $parameters = "timestamp=" . $timestamp;

    if ($payload != null) {
        foreach ($payload as $key => $value) {
            $parameters .= "&$key=$value";
        }
    }

    $sign = calculateHmacSha256($parameters, $API_SECRET);
    $url = "{$protocol}://{$host}{$api}?{$parameters}&signature={$sign}";

    $options = [
        "http" => [
            "header" => "X-BX-APIKEY: {$API_KEY}",
            "method" => $method
        ],
        "ssl" => [
            "verify_peer" => false,
            "verify_peer_name" => false
        ]
    ];

    $context = stream_context_create($options);
    $response = file_get_contents($url, false, $context);
    return $response;
}


function calculateHmacSha256($input, $key)
{
    $hash = hash_hmac("sha256", $input, $key, true);
    $hashHex = bin2hex($hash);
    return strtolower($hashHex);
}

// End of API Definition



if (str_contains($text, '/start'))
{
    $telegram->setText('Welcome admin 🌺')->setReplyMarkup($mainKeyboard)->sendMessage();
}



if ($text == '🔴 ON : OFF 🔴') {
    
    if ($base['Bot_On'] == 0) {
        
        $db->table('BASEDATA')->where('id', 1)->update(['Bot_On'], [1]);
        $telegram->setText('Robot ON 🟢')->setReplyMarkup($mainKeyboard)->sendMessage();
        
    } else {
        
        $db->table('BASEDATA')->where('id', 1)->update(['Bot_On'], [0]);
        $telegram->setText('Robot OFF 🔴')->setReplyMarkup($mainKeyboard)->sendMessage();
        
    }

    
} else if ($text == '🟢 Set Quantities 🟢') {
    
    if ($base['Bot_On'] == 1) {
        
        $api = [
            "uri" => "/openApi/swap/v2/user/balance",
            "method" => "GET",
            "payload" => [
    //             "symbol" => "BTC-USDT"
            ],
            "protocol" => "https"
        ];
    
        $response = doRequest($api["protocol"], HOST, $api["uri"], $api["method"], API_KEY, API_SECRET, $api["payload"]);
        $response = json_decode($response, true);
        $balance = floatval($response['data']['balance']['balance']);
    
        $api = [
            "uri" => "/openApi/swap/v2/quote/ticker",
            "method" => "GET",
            "payload" => [
                 "symbol" => "BTC-USDT"
            ],
            "protocol" => "https"
        ];
    
        $response = doRequest($api["protocol"], HOST, $api["uri"], $api["method"], API_KEY, API_SECRET, $api["payload"]);
        $response = json_decode($response, true);
        $lastPrice = floatval($response['data']['lastPrice']);
        $qty_ogn = round($balance/$lastPrice/2, 4, PHP_ROUND_HALF_DOWN);
        $qty_add = round($qty_ogn/5, 4, PHP_ROUND_HALF_DOWN);

/*    
        $api = [
            "uri" => "/openApi/swap/v2/quote/ticker",
            "method" => "GET",
            "payload" => [
                 "symbol" => "ETH-USDT"
            ],
            "protocol" => "https"
        ];
    
        $response = doRequest($api["protocol"], HOST, $api["uri"], $api["method"], API_KEY, API_SECRET, $api["payload"]);
        $response = json_decode($response, true);
        $lastPrice2 = floatval($response['data']['lastPrice']);
        $quantity2 = round($balance/$lastPrice2/2, 2, PHP_ROUND_HALF_DOWN);
*/    
        $db->table('BASEDATA')->where('id', 1)->update(['Bot_On', 'Balance', 'Qty_Ogn', 'Qty_Add'], [0, $balance, $qty_ogn, $qty_add]);
        $telegram->setText('Configured ✅')->setReplyMarkup($mainKeyboard)->sendMessage();

    } else {
        
        $telegram->setText('Turn on the bot!')->setReplyMarkup($mainKeyboard)->sendMessage();
        
    }

    
} else if ($text == '🟢 Open Positions 🟢') {
    
    if ($base['Bot_On'] == 1) {

        $api = [
            "uri" => "/openApi/swap/v2/trade/order",
            "method" => "POST",
            "payload" => [
                 "symbol" => "BTC-USDT",
                 "type" => "MARKET",
                 "side" => "BUY",
                 "positionSide" => "LONG",
                 "quantity" => $base['Qty_Ogn']
            ],
            "protocol" => "https"
        ];
    
        $response = doRequest($api["protocol"], HOST, $api["uri"], $api["method"], API_KEY, API_SECRET, $api["payload"]);
        $telegram->setText('BTC LONG ✅')->setReplyMarkup($mainKeyboard)->sendMessage();
    
        $api = [
            "uri" => "/openApi/swap/v2/trade/order",
            "method" => "POST",
            "payload" => [
                 "symbol" => "BTC-USDT",
                 "type" => "MARKET",
                 "side" => "SELL",
                 "positionSide" => "SHORT",
                 "quantity" => $base['Qty_Ogn']
            ],
            "protocol" => "https"
        ];
    
        $response = doRequest($api["protocol"], HOST, $api["uri"], $api["method"], API_KEY, API_SECRET, $api["payload"]);
        $telegram->setText('BTC SHORT ✅')->setReplyMarkup($mainKeyboard)->sendMessage();

        $db->table('BASEDATA')->where('id', 1)->update(['Bot_On'], [0]);
    
    } else {
        
        $telegram->setText('Turn on the bot!')->setReplyMarkup($mainKeyboard)->sendMessage();
        
    }
    

} else if ($text == '➕ Add Long ➕') {
    
    if ($base['Bot_On'] == 1) {

        $api = [
            "uri" => "/openApi/swap/v2/trade/order",
            "method" => "POST",
            "payload" => [
                 "symbol" => "BTC-USDT",
                 "type" => "MARKET",
                 "side" => "BUY",
                 "positionSide" => "LONG",
                 "quantity" => $base['$Qty_Add']
            ],
            "protocol" => "https"
        ];
    
        $response = doRequest($api["protocol"], HOST, $api["uri"], $api["method"], API_KEY, API_SECRET, $api["payload"]);
        $db->table('BASEDATA')->where('id', 1)->update(['Bot_On'], [0]);
        $telegram->setText('BTC Long Added ✅')->setReplyMarkup($mainKeyboard)->sendMessage();

    } else {
        
        $telegram->setText('Turn on the bot!')->setReplyMarkup($mainKeyboard)->sendMessage();
        
    }
        
} else if ($text == '➕ Add Short ➕') {

    if ($base['Bot_On'] == 1) {

        $api = [
            "uri" => "/openApi/swap/v2/trade/order",
            "method" => "POST",
            "payload" => [
                 "symbol" => "BTC-USDT",
                 "type" => "MARKET",
                 "side" => "SELL",
                 "positionSide" => "SHORT",
                 "quantity" => $base['$Qty_Add']
            ],
            "protocol" => "https"
        ];
    
        $response = doRequest($api["protocol"], HOST, $api["uri"], $api["method"], API_KEY, API_SECRET, $api["payload"]);
        $db->table('BASEDATA')->where('id', 1)->update(['Bot_On'], [0]);
        $telegram->setText('BTC Short Added ✅')->setReplyMarkup($mainKeyboard)->sendMessage();
    
    } else {
        
        $telegram->setText('Turn on the bot!')->setReplyMarkup($mainKeyboard)->sendMessage();
        
    }
    
}


/*
else if ($text == '🛜 Scan Now 🛜') {

    while ($base['is_bot_on'] == 1) {

        if (fmod(rand(100, 900), 5) == 0) {
            
            $bing_prices[41] = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0];
            $pair = $db->table('PAIRS')->where('id', 1)->first();
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair001']);
            $response = json_decode($response, true);
            $bing_prices[1] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair002']);
            $response = json_decode($response, true);
            $bing_prices[2] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair003']);
            $response = json_decode($response, true);
            $bing_prices[3] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair004']);
            $response = json_decode($response, true);
            $bing_prices[4] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair005']);
            $response = json_decode($response, true);
            $bing_prices[5] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair006']);
            $response = json_decode($response, true);
            $bing_prices[6] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair007']);
            $response = json_decode($response, true);
            $bing_prices[7] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair008']);
            $response = json_decode($response, true);
            $bing_prices[8] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair009']);
            $response = json_decode($response, true);
            $bing_prices[9] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair010']);
            $response = json_decode($response, true);
            $bing_prices[10] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair011']);
            $response = json_decode($response, true);
            $bing_prices[11] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair012']);
            $response = json_decode($response, true);
            $bing_prices[12] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair013']);
            $response = json_decode($response, true);
            $bing_prices[13] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair014']);
            $response = json_decode($response, true);
            $bing_prices[14] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair015']);
            $response = json_decode($response, true);
            $bing_prices[15] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair016']);
            $response = json_decode($response, true);
            $bing_prices[16] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair017']);
            $response = json_decode($response, true);
            $bing_prices[17] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair018']);
            $response = json_decode($response, true);
            $bing_prices[18] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair019']);
            $response = json_decode($response, true);
            $bing_prices[19] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair020']);
            $response = json_decode($response, true);
            $bing_prices[20] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair021']);
            $response = json_decode($response, true);
            $bing_prices[21] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair022']);
            $response = json_decode($response, true);
            $bing_prices[22] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair023']);
            $response = json_decode($response, true);
            $bing_prices[23] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair024']);
            $response = json_decode($response, true);
            $bing_prices[24] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair025']);
            $response = json_decode($response, true);
            $bing_prices[25] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair026']);
            $response = json_decode($response, true);
            $bing_prices[26] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair027']);
            $response = json_decode($response, true);
            $bing_prices[27] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair028']);
            $response = json_decode($response, true);
            $bing_prices[28] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair029']);
            $response = json_decode($response, true);
            $bing_prices[29] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair030']);
            $response = json_decode($response, true);
            $bing_prices[30] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair031']);
            $response = json_decode($response, true);
            $bing_prices[31] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair032']);
            $response = json_decode($response, true);
            $bing_prices[32] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair033']);
            $response = json_decode($response, true);
            $bing_prices[33] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair034']);
            $response = json_decode($response, true);
            $bing_prices[34] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair035']);
            $response = json_decode($response, true);
            $bing_prices[35] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair036']);
            $response = json_decode($response, true);
            $bing_prices[36] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair037']);
            $response = json_decode($response, true);
            $bing_prices[37] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair038']);
            $response = json_decode($response, true);
            $bing_prices[38] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair039']);
            $response = json_decode($response, true);
            $bing_prices[39] = floatval($response['data'][0]['trades'][0]['price']);
            $response = file_get_contents("https://open-api.bingx.com/openApi/spot/v1/ticker/price?symbol=" . $pair['Pair040']);
            $response = json_decode($response, true);
            $bing_prices[40] = floatval($response['data'][0]['trades'][0]['price']);
    
            $db->table('PRICES')->where('id', 1)->update(['Price001', 'Price002', 'Price003', 'Price004', 'Price005', 'Price006', 'Price007', 'Price008', 'Price009', 'Price010', 'Price011', 'Price012', 'Price013', 'Price014', 'Price015', 'Price016', 'Price017', 'Price018', 'Price019', 'Price020', 'Price021', 'Price022', 'Price023', 'Price024', 'Price025', 'Price026', 'Price027', 'Price028', 'Price029', 'Price030', 'Price031', 'Price032', 'Price033', 'Price034', 'Price035', 'Price036', 'Price037', 'Price038', 'Price039', 'Price040'], [$bing_prices[1], $bing_prices[2], $bing_prices[3], $bing_prices[4], $bing_prices[5], $bing_prices[6], $bing_prices[7], $bing_prices[8], $bing_prices[9], $bing_prices[10], $bing_prices[11], $bing_prices[12], $bing_prices[13], $bing_prices[14], $bing_prices[15], $bing_prices[16], $bing_prices[17], $bing_prices[18], $bing_prices[19], $bing_prices[20], $bing_prices[21], $bing_prices[22], $bing_prices[23], $bing_prices[24], $bing_prices[25], $bing_prices[26], $bing_prices[27], $bing_prices[28], $bing_prices[29], $bing_prices[30], $bing_prices[31], $bing_prices[32], $bing_prices[33], $bing_prices[34], $bing_prices[35], $bing_prices[36], $bing_prices[37], $bing_prices[38], $bing_prices[39], $bing_prices[40]]);
        
    
            $base_prices[41] = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0];
            $pair = $db->table('PAIRS')->where('id', 2)->first();
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair001']);
            $response = json_decode($response, true);
            $base_prices[1] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair002']);
            $response = json_decode($response, true);
            $base_prices[2] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair003']);
            $response = json_decode($response, true);
            $base_prices[3] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair004']);
            $response = json_decode($response, true);
            $base_prices[4] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair005']);
            $response = json_decode($response, true);
            $base_prices[5] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair006']);
            $response = json_decode($response, true);
            $base_prices[6] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair007']);
            $response = json_decode($response, true);
            $base_prices[7] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair008']);
            $response = json_decode($response, true);
            $base_prices[8] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair009']);
            $response = json_decode($response, true);
            $base_prices[9] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair010']);
            $response = json_decode($response, true);
            $base_prices[10] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair011']);
            $response = json_decode($response, true);
            $base_prices[11] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair012']);
            $response = json_decode($response, true);
            $base_prices[12] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair013']);
            $response = json_decode($response, true);
            $base_prices[13] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair014']);
            $response = json_decode($response, true);
            $base_prices[14] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair015']);
            $response = json_decode($response, true);
            $base_prices[15] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair016']);
            $response = json_decode($response, true);
            $base_prices[16] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair017']);
            $response = json_decode($response, true);
            $base_prices[17] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair018']);
            $response = json_decode($response, true);
            $base_prices[18] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair019']);
            $response = json_decode($response, true);
            $base_prices[19] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair020']);
            $response = json_decode($response, true);
            $base_prices[20] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair021']);
            $response = json_decode($response, true);
            $base_prices[21] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair022']);
            $response = json_decode($response, true);
            $base_prices[22] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair023']);
            $response = json_decode($response, true);
            $base_prices[23] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair024']);
            $response = json_decode($response, true);
            $base_prices[24] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair025']);
            $response = json_decode($response, true);
            $base_prices[25] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair026']);
            $response = json_decode($response, true);
            $base_prices[26] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair027']);
            $response = json_decode($response, true);
            $base_prices[27] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair028']);
            $response = json_decode($response, true);
            $base_prices[28] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair029']);
            $response = json_decode($response, true);
            $base_prices[29] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair030']);
            $response = json_decode($response, true);
            $base_prices[30] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair031']);
            $response = json_decode($response, true);
            $base_prices[31] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair032']);
            $response = json_decode($response, true);
            $base_prices[32] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair033']);
            $response = json_decode($response, true);
            $base_prices[33] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair034']);
            $response = json_decode($response, true);
            $base_prices[34] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair035']);
            $response = json_decode($response, true);
            $base_prices[35] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair036']);
            $response = json_decode($response, true);
            $base_prices[36] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair037']);
            $response = json_decode($response, true);
            $base_prices[37] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair038']);
            $response = json_decode($response, true);
            $base_prices[38] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair039']);
            $response = json_decode($response, true);
            $base_prices[39] = floatval($response['price']);
            $response = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=" . $pair['Pair040']);
            $response = json_decode($response, true);
            $base_prices[40] = floatval($response['price']);
    
            $db->table('PRICES')->where('id', 2)->update(['Price001', 'Price002', 'Price003', 'Price004', 'Price005', 'Price006', 'Price007', 'Price008', 'Price009', 'Price010', 'Price011', 'Price012', 'Price013', 'Price014', 'Price015', 'Price016', 'Price017', 'Price018', 'Price019', 'Price020', 'Price021', 'Price022', 'Price023', 'Price024', 'Price025', 'Price026', 'Price027', 'Price028', 'Price029', 'Price030', 'Price031', 'Price032', 'Price033', 'Price034', 'Price035', 'Price036', 'Price037', 'Price038', 'Price039', 'Price040'], [$base_prices[1], $base_prices[2], $base_prices[3], $base_prices[4], $base_prices[5], $base_prices[6], $base_prices[7], $base_prices[8], $base_prices[9], $base_prices[10], $base_prices[11], $base_prices[12], $base_prices[13], $base_prices[14], $base_prices[15], $base_prices[16], $base_prices[17], $base_prices[18], $base_prices[19], $base_prices[20], $base_prices[21], $base_prices[22], $base_prices[23], $base_prices[24], $base_prices[25], $base_prices[26], $base_prices[27], $base_prices[28], $base_prices[29], $base_prices[30], $base_prices[31], $base_prices[32], $base_prices[33], $base_prices[34], $base_prices[35], $base_prices[36], $base_prices[37], $base_prices[38], $base_prices[39], $base_prices[40]]);
            
            $pBing = $db->table('PRICES')->where('id', 1)->first();
            $pBase = $db->table('PRICES')->where('id', 2)->first();
    
            $percentage[21] = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0];
        
            $percentage[1] = 100*(max($pBing['Price001'], $pBase['Price001']) - min($pBing['Price001'], $pBase['Price001']))/min($pBing['Price001'], $pBase['Price001']);     
            $percentage[2] = 100*(max($pBing['Price002'], $pBase['Price002']) - min($pBing['Price002'], $pBase['Price002']))/min($pBing['Price002'], $pBase['Price002']);     
            $percentage[3] = 100*(max($pBing['Price003'], $pBase['Price003']) - min($pBing['Price003'], $pBase['Price003']))/min($pBing['Price003'], $pBase['Price003']);     
            $percentage[4] = 100*(max($pBing['Price004'], $pBase['Price004']) - min($pBing['Price004'], $pBase['Price004']))/min($pBing['Price004'], $pBase['Price004']);     
            $percentage[5] = 100*(max($pBing['Price005'], $pBase['Price005']) - min($pBing['Price005'], $pBase['Price005']))/min($pBing['Price005'], $pBase['Price005']);     
            $percentage[6] = 100*(max($pBing['Price006'], $pBase['Price006']) - min($pBing['Price006'], $pBase['Price006']))/min($pBing['Price006'], $pBase['Price006']);     
            $percentage[7] = 100*(max($pBing['Price007'], $pBase['Price007']) - min($pBing['Price007'], $pBase['Price007']))/min($pBing['Price007'], $pBase['Price007']);     
            $percentage[8] = 100*(max($pBing['Price008'], $pBase['Price008']) - min($pBing['Price008'], $pBase['Price008']))/min($pBing['Price008'], $pBase['Price008']);     
            $percentage[9] = 100*(max($pBing['Price009'], $pBase['Price009']) - min($pBing['Price009'], $pBase['Price009']))/min($pBing['Price009'], $pBase['Price009']);     
            $percentage[10] = 100*(max($pBing['Price010'], $pBase['Price010']) - min($pBing['Price010'], $pBase['Price010']))/min($pBing['Price010'], $pBase['Price010']);     
            $percentage[11] = 100*(max($pBing['Price011'], $pBase['Price011']) - min($pBing['Price011'], $pBase['Price011']))/min($pBing['Price011'], $pBase['Price011']);     
            $percentage[12] = 100*(max($pBing['Price012'], $pBase['Price012']) - min($pBing['Price012'], $pBase['Price012']))/min($pBing['Price012'], $pBase['Price012']);     
            $percentage[13] = 100*(max($pBing['Price013'], $pBase['Price013']) - min($pBing['Price013'], $pBase['Price013']))/min($pBing['Price013'], $pBase['Price013']);     
            $percentage[14] = 100*(max($pBing['Price014'], $pBase['Price014']) - min($pBing['Price014'], $pBase['Price014']))/min($pBing['Price014'], $pBase['Price014']);     
            $percentage[15] = 100*(max($pBing['Price015'], $pBase['Price015']) - min($pBing['Price015'], $pBase['Price015']))/min($pBing['Price015'], $pBase['Price015']);     
            $percentage[16] = 100*(max($pBing['Price016'], $pBase['Price016']) - min($pBing['Price016'], $pBase['Price016']))/min($pBing['Price016'], $pBase['Price016']);     
            $percentage[17] = 100*(max($pBing['Price017'], $pBase['Price017']) - min($pBing['Price017'], $pBase['Price017']))/min($pBing['Price017'], $pBase['Price017']);     
            $percentage[18] = 100*(max($pBing['Price018'], $pBase['Price018']) - min($pBing['Price018'], $pBase['Price018']))/min($pBing['Price018'], $pBase['Price018']);     
            $percentage[19] = 100*(max($pBing['Price019'], $pBase['Price019']) - min($pBing['Price019'], $pBase['Price019']))/min($pBing['Price019'], $pBase['Price019']);     
            $percentage[20] = 100*(max($pBing['Price020'], $pBase['Price020']) - min($pBing['Price020'], $pBase['Price020']))/min($pBing['Price020'], $pBase['Price020']);     
            $percentage[21] = 100*(max($pBing['Price021'], $pBase['Price021']) - min($pBing['Price021'], $pBase['Price021']))/min($pBing['Price021'], $pBase['Price021']);     
            $percentage[22] = 100*(max($pBing['Price022'], $pBase['Price022']) - min($pBing['Price022'], $pBase['Price022']))/min($pBing['Price022'], $pBase['Price022']);     
            $percentage[23] = 100*(max($pBing['Price023'], $pBase['Price023']) - min($pBing['Price023'], $pBase['Price023']))/min($pBing['Price023'], $pBase['Price023']);     
            $percentage[24] = 100*(max($pBing['Price024'], $pBase['Price024']) - min($pBing['Price024'], $pBase['Price024']))/min($pBing['Price024'], $pBase['Price024']);     
            $percentage[25] = 100*(max($pBing['Price025'], $pBase['Price025']) - min($pBing['Price025'], $pBase['Price025']))/min($pBing['Price025'], $pBase['Price025']);     
            $percentage[26] = 100*(max($pBing['Price026'], $pBase['Price026']) - min($pBing['Price026'], $pBase['Price026']))/min($pBing['Price026'], $pBase['Price026']);     
            $percentage[27] = 100*(max($pBing['Price027'], $pBase['Price027']) - min($pBing['Price027'], $pBase['Price027']))/min($pBing['Price027'], $pBase['Price027']);     
            $percentage[28] = 100*(max($pBing['Price028'], $pBase['Price028']) - min($pBing['Price028'], $pBase['Price028']))/min($pBing['Price028'], $pBase['Price028']);     
            $percentage[29] = 100*(max($pBing['Price029'], $pBase['Price029']) - min($pBing['Price029'], $pBase['Price029']))/min($pBing['Price029'], $pBase['Price029']);     
            $percentage[30] = 100*(max($pBing['Price030'], $pBase['Price030']) - min($pBing['Price030'], $pBase['Price030']))/min($pBing['Price030'], $pBase['Price030']);     
            $percentage[31] = 100*(max($pBing['Price031'], $pBase['Price031']) - min($pBing['Price031'], $pBase['Price031']))/min($pBing['Price031'], $pBase['Price031']);     
            $percentage[32] = 100*(max($pBing['Price032'], $pBase['Price032']) - min($pBing['Price032'], $pBase['Price032']))/min($pBing['Price032'], $pBase['Price032']);     
            $percentage[33] = 100*(max($pBing['Price033'], $pBase['Price033']) - min($pBing['Price033'], $pBase['Price033']))/min($pBing['Price033'], $pBase['Price033']);     
            $percentage[34] = 100*(max($pBing['Price034'], $pBase['Price034']) - min($pBing['Price034'], $pBase['Price034']))/min($pBing['Price034'], $pBase['Price034']);     
            $percentage[35] = 100*(max($pBing['Price035'], $pBase['Price035']) - min($pBing['Price035'], $pBase['Price035']))/min($pBing['Price035'], $pBase['Price035']);     
            $percentage[36] = 100*(max($pBing['Price036'], $pBase['Price036']) - min($pBing['Price036'], $pBase['Price036']))/min($pBing['Price036'], $pBase['Price036']);     
            $percentage[37] = 100*(max($pBing['Price037'], $pBase['Price037']) - min($pBing['Price037'], $pBase['Price037']))/min($pBing['Price037'], $pBase['Price037']);     
            $percentage[38] = 100*(max($pBing['Price038'], $pBase['Price038']) - min($pBing['Price038'], $pBase['Price038']))/min($pBing['Price038'], $pBase['Price038']);     
            $percentage[39] = 100*(max($pBing['Price039'], $pBase['Price039']) - min($pBing['Price039'], $pBase['Price039']))/min($pBing['Price039'], $pBase['Price039']);     
            $percentage[40] = 100*(max($pBing['Price040'], $pBase['Price040']) - min($pBing['Price040'], $pBase['Price040']))/min($pBing['Price040'], $pBase['Price040']);     
    
            $db->table('ARBIT')->where('id', 1)->update(['Arbit001', 'Arbit002', 'Arbit003', 'Arbit004', 'Arbit005', 'Arbit006', 'Arbit007', 'Arbit008', 'Arbit009', 'Arbit010', 'Arbit011', 'Arbit012', 'Arbit013', 'Arbit014', 'Arbit015', 'Arbit016', 'Arbit017', 'Arbit018', 'Arbit019', 'Arbit020', 'Arbit021', 'Arbit022', 'Arbit023', 'Arbit024', 'Arbit025', 'Arbit026', 'Arbit027', 'Arbit028', 'Arbit029', 'Arbit030', 'Arbit031', 'Arbit032', 'Arbit033', 'Arbit034', 'Arbit035', 'Arbit036', 'Arbit037', 'Arbit038', 'Arbit039', 'Arbit040'], [round($percentage[1], 2), round($percentage[2], 2), round($percentage[3], 2), round($percentage[4], 2), round($percentage[5], 2), round($percentage[6], 2), round($percentage[7], 2), round($percentage[8], 2), round($percentage[9], 2), round($percentage[10], 2), round($percentage[11], 2), round($percentage[12], 2), round($percentage[13], 2), round($percentage[14], 2), round($percentage[15], 2), round($percentage[16], 2), round($percentage[17], 2), round($percentage[18], 2), round($percentage[19], 2), round($percentage[20], 2), round($percentage[21], 2), round($percentage[22], 2), round($percentage[23], 2), round($percentage[24], 2), round($percentage[25], 2), round($percentage[26], 2), round($percentage[27], 2), round($percentage[28], 2), round($percentage[29], 2), round($percentage[30], 2), round($percentage[31], 2), round($percentage[32], 2), round($percentage[33], 2), round($percentage[34], 2), round($percentage[35], 2), round($percentage[36], 2), round($percentage[37], 2), round($percentage[38], 2), round($percentage[39], 2), round($percentage[40], 2)]);
            
            $pairover = $db->table('PAIRS')->where('id', 1)->first();
            $percentageover = $db->table('ARBIT')->where('id', 1)->first();
            
            if ($percentageover['Arbit001'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair001'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit001'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price001'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price001'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit002'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair002'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit002'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price002'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price002'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit003'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair003'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit003'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price003'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price003'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit004'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair004'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit004'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price004'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price004'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit005'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair005'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit005'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price005'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price005'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit006'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair006'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit006'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price006'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price006'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit007'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair007'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit007'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price007'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price007'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit008'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair008'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit008'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price008'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price008'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit009'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair009'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit009'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price009'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price009'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit010'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair010'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit010'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price010'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price010'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit011'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair011'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit011'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price011'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price011'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit012'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair012'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit012'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price012'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price012'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit013'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair013'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit013'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price013'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price013'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit014'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair014'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit014'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price014'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price014'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit015'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair015'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit015'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price015'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price015'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit016'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair016'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit016'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price016'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price016'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit017'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair017'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit017'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price017'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price017'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit018'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair018'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit018'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price018'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price018'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit019'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair019'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit019'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price019'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price019'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit020'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair020'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit020'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price020'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price020'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit021'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair021'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit021'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price021'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price021'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit022'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair022'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit022'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price022'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price022'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit023'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair023'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit023'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price023'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price023'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit024'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair024'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit024'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price024'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price024'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit025'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair025'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit025'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price025'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price025'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit026'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair026'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit026'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price026'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price026'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit027'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair027'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit027'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price027'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price027'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit028'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair028'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit028'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price028'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price028'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit029'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair029'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit029'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price029'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price029'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit030'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair030'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit030'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price030'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price030'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit031'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair031'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit031'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price031'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price031'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit032'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair032'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit032'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price032'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price032'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit033'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair033'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit033'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price033'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price033'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit034'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair034'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit034'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price034'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price034'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit035'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair035'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit035'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price035'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price035'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit036'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair036'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit036'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price036'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price036'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit037'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair037'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit037'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price037'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price037'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit038'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair038'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit038'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price038'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price038'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit039'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair039'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit039'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price039'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price039'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
            if ($percentageover['Arbit040'] >= 2) {
                $text_send = '❇️ ';
                $text_send .= $pairover['Pair040'] . "\n";
                $text_send .= 'Percent: %' . $percentageover['Arbit040'] . "\n";
                $text_send .= $base['updated_at'] . "\n\n";
                $text_send .= 'BING: $' . $pBing['Price040'] . "\n";
                $text_send .= 'BASE: $' . $pBase['Price040'] . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
        
            $db->table('BASEDATA')->where('id', 1)->update(['scan_num'], [$base['scan_num'] +1 ]);
            $base = $db->table('BASEDATA')->where('id', 1)->first();
            if (fmod($base['scan_num'], 50) == 0) {
                
                $telegram->setText('I am still working...')->setReplyMarkup($mainKeyboard)->sendMessage();
                
            }
            
        } // end if
        
    } // end while

    $telegram->setText('⛔️ Scan stopped.')->setReplyMarkup($mainKeyboard)->sendMessage();
    return;
        
}
*/