<?php

require_once('config.php');
require_once('telegram_json.php');
require_once('Classes/DBConnection.php');
require_once('Classes/DB.php');
require_once('Classes/TelegramService.php');
require_once('Classes/Telegram.php');
require_once('helper.php');
require_once('default_keyboard.php');

use Classes\DB;
use Classes\Telegram;


global $db;
global $telegram;
global $user;
global $base;
global $deposit_hash;
global $double_hash;
global $double_address;


$db = new DB();
$telegram = new Telegram();
$double_hash = 0;
$double_address = 0;


$base = $db->table('BASEDATA')->where(1, 1)->first();

$user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

$deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $chat_id)->where('run_day', $base['run_day'])->first();

/*
if ($user['user_block'] == 1) {
    
    if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
        $text_send = '⛔️ اکانت شما مسدود است.' . "\n\n";
        $text_send .= urlencode("----------------------------") . "\n" . 'با احترام' . "\n" . 'پلتفرم آناوست'. "\n" . 'دپارتمان سرمایه‌گذاری آناناکی ' . urlencode("Ananaki.com");
        $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        return;
    
    } else {
        $text_send = '⛔️ Your account is blocked.' . "\n\n";
        $text_send .= urlencode("----------------------------") . "\n" . 'Yours,' . "\n" . 'Anavest Platform' . "\n" . 'Investment Department of ' . urlencode("Ananaki.com");
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        return;
    }

    return;
}

if (!$base['is_bot_on'] && !$user['is_admin'] && $user['user_tel_id'] != '732726548') {
    
    if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
        $text_send = '🔴 پلتفرم هر روز از ساعت ۱۰ تا ۱۲ شب به وقت ایران خاموش است تا سود کاربران را محاسبه و واریز نماید. لطفاً بعد از ساعت ۱۲ شب مراجعه نمایید. ضمناً، وضعیت واریزی سود را می‌توانید از بلاکچین بایننس (کیف پولتان) و همینطور از منوی "آمار من" پلتفرم چک نمایید.' . "\n\n";
        $text_send .= urlencode("----------------------------") . "\n" . 'با احترام' . "\n" . 'پلتفرم آناوست'. "\n" . 'دپارتمان سرمایه‌گذاری آناناکی ' . urlencode("Ananaki.com");
        $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        return;
    
    } else {
        $text_send = '🔴 The platform is closed every day from 18:30 to 20:30 UTC to calculate and deposit the profit of users. Please come back after 20:30 UTC. In addition, you can check your profit status from the Binance Smartchain (i.e. your wallet), and also from the "Stats" menu of the platform.' . "\n\n";
        $text_send .= urlencode("----------------------------") . "\n" . 'Yours,' . "\n" . 'Anavest Platform' . "\n" . 'Investment Department of ' . urlencode("Ananaki.com");
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        return;
    }

    return;
}
*/


if (empty($user)) {
    
    $db->table('USERS')->insert(['user_tel_id'], [$chat_id]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
}

if (empty($deposit_hash) && !$user['is_admin']) {
    
    $db->table('DEPOSITS')->insert(['run_day', 'user_tel_id'], [$base['run_day'], $user['user_tel_id']]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();
}


if (str_contains($text, '/start')) {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    if (str_contains($text, '/start ')) {
        $refer = str_replace("/start ","", $text);
        $before_referred = $db->table('REFERRALS')->where('referral', $chat_id)->first();
        if (empty($before_referred) && $refer != $chat_id) {
            $db->table('REFERRALS')->insert(['referrer', 'referral'], [$refer, $chat_id]);
        }

    } else {
        $before_referred = $db->table('REFERRALS')->where('referral', $chat_id)->first();
        if (empty($before_referred)) {
            $db->table('REFERRALS')->insert(['referrer', 'referral'], ['0000000000', $chat_id]);
        }
    }

    if ($user['is_admin']) {
        $telegram->setText('Welcome admin...')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
    
    } else if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
        $text_send = '❇️ به پلتفرم آناوست خوش آمدید.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
    
    } else {
        $text_send = '❇️ Welcome to the Anavest platform.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    }

    return;
}


if ($text == '🎟 Investment 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
/*
    if ($user['wallet_address'] == NULL) {
        $text_send = 'First, submit your BEP20 wallet address using the "Wallet" menu.';
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        return;
    }
*/
    $text_send = '⛔️ Attention:' . "\n\n";
    $text_send .= '1) We no longer accept new investors.' . "\n\n";
    $text_send .= '2) On April 15, 2024, half of the old investors money will be converted into ANA tokens (with a price of $0.5 per token) and the remaining half will be returned to their wallets within a few days. Users who have already bought ANA tokens themselves are included in the above calculations.' . "\n\n";
    $text_send .= '3) ANA will be launched at least at the price of 1 USDT, but when? Whenever investors grow the Ananaki Instagram page to 300,000 followers, then the token will be launched. In case of launch, users capital will increase 10 to 100 times. We have prepared the ground, now it is your turn to achieve several thousand percent profit with your activity. So create a campaign and do whatever it takes to grow the page and launch the token.' . "\n\n";
    $text_send .= '4) If the Instagram page does not grow, the token will not be launched. In this case, the company will return the money of those who have worked to grow the page every day (their activity is determined by comments, mentions and sharing of posts). In addition, ANA does not have a monthly profit, but its profit is only at its launch.' . "\n\n";
    $text_send .= '5) Supporters of the platform are always responsive but they ignore repetitive and irrelevant questions.' . "\n\n";
    $text_send .= 'Ananaki Instagram address:' . "\n";
    $text_send .= 'https://www.instagram.com/ana.naki?igsh=cWdzdTJ5NGR5cnZh' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();

/*    
} else if ($text == '🎟 Deposit 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $chat_id)->where('run_day', $base['run_day'])->update(['part_flag'], [1]);

    if ($user['DayInv'] > 0) {
        $text_send = '🟢 Dear user, in order to reduce the traffic of the platform, each user can make a deposit once a day. Please wait until the next day to deposit the new amount.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        return;
    }


    $text_send = 'STEP 1️⃣' . "\n" . 'Transfer the amount you want to invest (USDT BEP20) to the following address. Transaction must be performed by your own registered wallet.' . "\n\n";
    $text_send .= '0x' . $base['base_address'] . "\n\n";
    $text_send .= 'STEP 2️⃣' . "\n" . 'When transaction is completed, send its hash (TXID) to the platform.' . "\n\n";
    $text_send .= 'STEP 3️⃣' . "\n" . 'Press "Confirm My Hash"  Button.' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($hashKeyboard)->sendMessage();


} else if ($text == '✅ Confirm My Hash ✅') {
    
    if ($user['DayInv'] > 0) {
        $text_send = '🟢 Dear user, in order to reduce the traffic of the platform, each user can make a deposit once a day. Please wait until the next day to deposit the new amount.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        return;
    }

    $bsc_url = json_decode(file_get_contents('https://api.bscscan.com/api?module=proxy&action=eth_getTransactionReceipt&txhash=' . $deposit_hash['trans_hash']. '&apikey=' . BSC_API), true);

    if (hexdec($bsc_url['result']['blockNumber']) < 34960593) {
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = '⛔️ این هش قدیمی یا تکراری است.';
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            return;
        } else {
            $text_send = '⛔️ This hash is old or duplicate.' . "\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            return;
        }
        return;
    }

    if ($bsc_url == NULL) {

        $db->table('DEPOSITS')->where('user_tel_id', $chat_id)->where('run_day', $base['run_day'])->update(['trans_hash'], [NULL]);
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = '⛔️ به دلیل شلوغی بلاکچین، تاییدیه دریافت نشد. لطفاً هش را دوباره ارسال نمایید.';
            $telegram->setText($text_send)->setReplyMarkup($hashKeyboard)->sendMessage();
        } else {
            $text_send = '⛔️ No confirmation was received due to the blockchain congestion. Please resend the hash.' . "\n";
            $telegram->setText($text_send)->setReplyMarkup($hashKeyboard)->sendMessage();
        }

    } else if (hexdec($bsc_url['result']['status']) == 1) {
        if (str_contains($bsc_url['result']['logs']['0']['topics'][2], strtolower($base['base_address']))) {
            if (str_contains(strtolower($bsc_url['result']['from']), strtolower($user['wallet_address']))) {
                if (str_contains($bsc_url['result']['to'], strtolower($base['contract_address']))) {
                        
                    $amount_transferred = floor(hexdec($bsc_url['result']['logs']['0']['data'])/pow(10, 18));
                    if ($user['Days'] != -1) {
                        $user['Days'] = floor($user['Days']*($user['Invested']/($amount_transferred + $user['Invested'])));
                    }
                    $user['Invested'] += $amount_transferred;
                    $user['DayInv'] = $amount_transferred;
                    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['Invested', 'Days', 'DayInv'], [$user['Invested'], $user['Days'], $user['DayInv']]);
                    $db->table('DEPOSITS')->where('user_tel_id', $chat_id)->where('run_day', $base['run_day'])->update(['part_flag', 'hash_confirmed'], [0, 1]);
                    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

                    $active_ref = $db->table('REFERRALS')->where('referral', $chat_id)->first();
                    if (!empty($active_ref)) {
                        if ($user['Invested']>=100) {
                            $referrer = $db->table('USERS')->where('user_tel_id', $active_ref['referrer'])->first();
                            $db->table('USERS')->where('user_tel_id', $referrer['user_tel_id'])->update(['SubInvest'], [$referrer['SubInvest'] + $amount_transferred]);
                        }
                    }
                        
                    if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
                        $text_send = '✅ تراکنش شما تایید شد.' . "\n\n";
                        $text_send .= 'مبلغ: ' . $amount_transferred . ' تتر';
                        $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
                    } else {
                        $text_send = '✅ Your transaction confirmed.' . "\n\n";
                        $text_send .= 'Amount: ' . $amount_transferred . ' USDT';
                        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
                    }
                }
                        
            } else {
                        $db->table('DEPOSITS')->where('user_tel_id', $chat_id)->where('run_day', $base['run_day'])->update(['part_flag', 'hash_confirmed'], [0, 0]);
                        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
                            $text_send = '⛔️ تراکنش باید توسط کیف پول خودتان انجام شود.';
                            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
                        } else {
                            $text_send = '⛔️ Transaction must be performed by your own registered wallet.' . "\n";
                            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
                        }
                    }
        } else {
            $db->table('DEPOSITS')->where('user_tel_id', $chat_id)->where('run_day', $base['run_day'])->update(['part_flag', 'hash_confirmed'], [0, 0]);
            if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
                $text_send = '⛔️ شما مبلغ را به آدرس دیگری ارسال کرده‌اید!';
                $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
            } else {
                $text_send = '⛔️ You have sent the amount to another address!' . "\n";
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
        }
    } else {
        $db->table('DEPOSITS')->where('user_tel_id', $chat_id)->where('run_day', $base['run_day'])->update(['part_flag', 'hash_confirmed'], [0, 0]);
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = '⛔️ هش نامعتبر است!';
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        } else {
            $text_send = '⛔️ Invalid hash! Please send a valid transaction hash (TXID) to the platform.' . "\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
    }
    return;
    

} else if ($text == '🎟 Withdraw 🎟') {

    $telegram->setText('Please read the "Investment Rules".')->setReplyMarkup($mainKeyboard)->sendMessage();

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 1, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['WMonth'] == 0) {
        $text_send = 'Total Investment: ' . $user['Invested'] . ' USDT' . "\n";
        $text_send .= 'Withdrawable Amount: ' . $user['Invested'] . ' USDT' . "\n\n";
        $text_send .= '1) Type the amount of withdrawal.' . "\n";
        $text_send .= '2) Send it to the bot.' . "\n";
        $text_send .= '3) Press the "Confirm" button.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($withdrawKeyboard)->sendMessage();
    } else {
        $text_send = '⛔️ You can make withdrawal requests only once a month. Please wait for the next month.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($investmentKeyboard)->sendMessage();
    }

    return;
    
    
} else if ($text == '✅ Confirm ✅') { // Withdraw

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['WPend'] <= $user['Invested']) {
        $db->table('USERS')->where('user_tel_id', $chat_id)->update(['Invested', 'WMonth'], [$user['Invested'] - $user['WPend'], 1]);
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = 'درخواست برداشت مبلغ ' . $user['WPend'] . ' تتر' . ' ثبت گردید ✅' . "\n\n";
            $text_send .= 'سرمایه باقیمانده: ' . $user['Invested'] - $user['WPend'] . ' تتر' . "\n\n";
            $text_send .= '🔵 درخواست اکنون در صف پردازش است. ممکن است چند ساعت تا چند روز طول بکشد تا پرداخت شود. درخواست‌ها به صورت خودکار انجام می‌شوند، بنابراین نیازی به ارسال پیام به پشتیبانی نیست.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        } else {
            $text_send = 'Withdraw of ' . $user['WPend'] . ' USDT' . ' is submitted ✅' . "\n\n";
            $text_send .= 'Remained Investment: ' . $user['Invested'] - $user['WPend'] . ' USDT' . "\n\n";
            $text_send .= '🔵 The request is now in the processing queue. It may take form a few hours to a few days to be paid. Requests are performed automatically, so there is no need to message the support.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
    } else {
        $db->table('USERS')->where('user_tel_id', $chat_id)->update(['WPend'], [0]);
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = '⛔️ موجودی شما کافی نیست.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        } else {
            $text_send = '⛔️ Not enough balance.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
    }
    return;

    
} else if ($text == '◼️ Cancel ◼️') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
        $text_send = 'لغو عملیات' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
    } else {
        $text_send = 'Cancel...' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    }

    
} else if ($text == '🎟 40X Reward 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $text_send = '❇️ 40X Reward Rules' . "\n\n";
    $text_send .= '1) Description' . "\n";
    $text_send .= 'Each day, each participant pays 10 USDT, and the money of 40 participants is paid to one person through a draw. The next days are the same, meaning participants pay 10 USDT every day until they win. The amount of participating in the plan is deducted from the user investment balance, and in case of winning, the reward is added to the user investment balance too.' . "\n\n";
    $text_send .= '2) Draws' . "\n";
    $text_send .= 'The draws will be made every day, provided that the number of participants reaches the quorum, otherwise it will be postponed to tomorrow. If there are more than 40 participants per day, we will have more than one winner. For example, if 76 people participate in the plan today, we will have 2 winners and 380 USDT for each.' . "\n\n";
    $text_send .= '3) Boosters and Chance Ratio' . "\n";
    $text_send .= 'At first, the chance of all participants is equal to 1. Participants can increase their chances through boosters of 18 units and 92 units. Also, for every referral that participates in the 40x plan, 36 units will be added to the referrer chance. In addition, for each day that the user continues to participate in the plan, 2^(Days+1) units will be added to his chance of winning. For example, if you participate on the fifth day, 64 units (equal to 2^6) will be added to your chance ratio. Sixth day, another 128 units and until the end.' . "\n\n";
    $text_send .= '4) Saving Chance Ratio' . "\n";
    $text_send .= 'The chance ratio of participants are saved until they win. When a user wins, his/her chance ratio is reset for the next round.' . "\n\n";
    $text_send .= '5) Best and Worst Cases' . "\n";
    $text_send .= 'The best case is when the participant wins on the very first day and his/her money returns 40 times. But in the worst case, the participant is expected to win with a profit of about 50%, considering the odds are saved for the next days. So the user will finally win in the range of days 25 and 26 depending on not neglecting boosters because other participants may constantly use boosters and get ahead of him/her.' . "\n\n";
    $text_send .= urlencode("----------------------------") . "\n" . 'Yours,' . "\n" . 'Anavest Platform' . "\n" . 'Investment Department of ' . urlencode("Ananaki.com");
    $telegram->setText($text_send)->setReplyMarkup($reward40xKeyboard)->sendMessage();
    return;
    
    
} else if ($text == '🎟 $10 => $400 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['P40X'] == 1) {
        $text_send = '✅ You have participated in this plan today. Please wait for the result.' . "\n\n";
        $text_send .= 'If you win, the amount will be added to your main balance (i.e. invested balance).' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($reward40xKeyboard)->sendMessage();

    } else {
        if ($user['Invested'] >= 10) {
            $db->table('USERS')->where('user_tel_id', $chat_id)->update(['Invested', 'P40X', 'BOOST', 'Paid40', 'Paidall'], [$user['Invested'] - 10, 1, $user['BOOST'] + pow(2, intdiv($user['Paid40'], 10) + 2), $user['Paid40'] + 10, $user['Paidall'] + 10]);
            $active_ref = $db->table('REFERRALS')->where('referral', $chat_id)->first();
            if (!empty($active_ref)) {
                $referrer = $db->table('USERS')->where('user_tel_id', $active_ref['referrer'])->first();
                $db->table('USERS')->where('user_tel_id', $referrer['user_tel_id'])->update(['BOOST'], [$referrer['BOOST'] + 36]);
            }
            $text_send = '✅ You Participated in 40X successfully.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($reward40xKeyboard)->sendMessage();

        } else {
            $text_send = '⛔️ You do not have enough balance.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
    }
    

} else if ($text == '🔝 Booster 🔝') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $text_send = '🔝️ Boosters increase your winning chance sharply. Which booster you want to activate?' . "\n\n";
    $text_send .= 'The amount will be deducted from your main balance (i.e. invested balance).' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($boosterKeyboard)->sendMessage();


} else if ($text == '🔝 18 Units ($12) 🔝') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['Invested'] >= 12) {
        $db->table('USERS')->where('user_tel_id', $chat_id)->update(['Invested', 'BOOST', 'BUY'], [$user['Invested'] - 12, $user['BOOST'] + 18, $user['BUY'] + 18] );
        $text_send = '✅ You boosted your chance 18 units.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($boosterKeyboard)->sendMessage();
    } else {
        $text_send = '⛔️ You do not have enough balance.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($boosterKeyboard)->sendMessage();
    }


} else if ($text == '🔝 92 Units ($30) 🔝') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['Invested'] >= 30) {
        $db->table('USERS')->where('user_tel_id', $chat_id)->update(['Invested', 'BOOST', 'BUY'], [$user['Invested'] - 30, $user['BOOST'] + 92, $user['BUY'] + 30]);
        $text_send = '✅ You boosted your chance 92 units.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($boosterKeyboard)->sendMessage();
    } else {
        $text_send = '⛔️ You do not have enough balance.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($boosterKeyboard)->sendMessage();
    }


} else if ($text == '🎟 Buy ANA Token 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 1]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $text_send = '❇️ ANA Token' . "\n\n";
    $text_send .= 'The ANA token is the only token of Ananaki company which includes the shares of its main projects (ANABEST - Projects No. 3). This token is the only gateway to enter the Ananaki ecosystem, replacing the "NEXT" token.' . "\n\n";
    $text_send .= '➖ You can buy ' . $user['Credit'] . ' number of ANA token with a price of $0.1 this week (the price of this week is 0.1 USDT).' . "\n";
    $text_send .= '➖ You current balance is ' . $user['Invested'] . ' USDT which equal to ' . round($user['Invested']*10, 2) . ' ANA token (meaning that you cannot buy more tokens unless you deposit extra USDT).' . "\n\n";
    $text_send .= 'How to buy ANA token?' . "\n";
    $text_send .= '1) First, type the number of tokens you want and send it to the bot. For example, if you tend to buy $200, type 2000 and send it.' . "\n";
    $text_send .= '2) Then press the "Buy Now" button and wait for the bot confirmation.' . "\n\n";
    $text_send .= urlencode("----------------------------") . "\n" . 'Yours,' . "\n" . 'Anavest Platform' . "\n" . 'Investment Department of ' . urlencode("Ananaki.com");
    $telegram->setText($text_send)->setReplyMarkup($buyANAKeyboard)->sendMessage();
    return;
    
    
} else if ($text == '🎟 Buy Now 🎟') { // Buy Token ANA

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['Credit'] <= 2) {

        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = '⛔️ شما اعتبار خرید توکن ندارید.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        } else {
            $text_send = '⛔️ Not enough credit.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
        
    } else if (round($user['ANAReq']/10, 2) <= $user['Invested']) {
        $db->table('USERS')->where('user_tel_id', $chat_id)->update(['Invested', 'ANA', 'Credit'], [$user['Invested'] - round($user['ANAReq']/10, 2), $user['ANA'] + $user['ANAReq'], $user['Credit'] - round($user['ANAReq'], 2)]);
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = '✅ خرید ' . $user['ANAReq'] . ' تعداد توکن آنا انجام شد.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        } else {
            $text_send = '✅ Purchase of ' . $user['ANAReq'] . ' ANA' . ' done.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
        $db->table('USERS')->where('user_tel_id', $chat_id)->update(['ANAReq'], [0]);

    } else {
        $db->table('USERS')->where('user_tel_id', $chat_id)->update(['ANAReq'], [0]);
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = '⛔️ موجودی شما کافی نیست.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        } else {
            $text_send = '⛔️ Not enough balance.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
    }
    return;
    
    
} else if ($text == '◾️ Return ◾️') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $telegram->setText('Return')->setReplyMarkup($reward40xKeyboard)->sendMessage();

*/
} else if ($text == '🔘 Language 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $telegram->setText('Choose your language.')->setReplyMarkup($langKeyboard)->sendMessage();
    return;
    
/*    
} else if ($text == '🧑 Invite Friends 🧑') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $text_send = '🎟 Anavest Investing Platform' . "\n\n";
    $text_send .= 'Your exclusive link to invite friends:' . "\n\n";
    $text_send .= 'https://t.me/anavestbot?start=' . $chat_id . "\n\n";
    $text_send .= urlencode("----------------------------") . "\n" . 'Yours,' . "\n" . 'Anavest Platform' . "\n" . 'Investment Department of ' . urlencode("Ananaki.com");
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;
*/

} else if ($text == '🔘 Stats 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $text_send = '♦️ My Telegram ID Number:' . "\n" . '  ➖️' . $user['user_tel_id'] . "\n\n";

    $text_send .= '🏆 My Investment:' . "\n";
    $text_send .= '  ➖ USDT: ' . $user['Invested'] . ' USDT' . "\n";
    $text_send .= '  ➖ ANA: ' . $user['ANA'] . ' ANA' . "\n";
/*
    $text_send .= '🏆 My 40X Reward:' . "\n";
    $text_send .= '  ➖ Step Number: ' . $user['Step40'] . "\n";
    $text_send .= '  ➖ My Won Times: ' . $user['W40X'] . "\n";
    $text_send .= '  ➖ Day Participated: ' . $user['P40X'] . "\n";
    $text_send .= '  ➖ My Paid This Step: ' . $user['Paid40'] . ' USDT' . "\n";
    $text_send .= '  ➖ My Total Paid: ' . $user['Paidall'] . ' USDT' . "\n";
    $text_send .= '  ➖ My Gained Amount: ' . $user['Gain40'] . ' USDT' . "\n";
    $text_send .= '  ➖ My Chance Ratio In Pack: ' . $user['BOOST'] . "\n";

    $i40info = $db->table('USERS')->where('P40X', 1)->get('*');
    $participants_num = count($i40info);
    $max_ratio = 0;

    foreach($i40info as $i40i) {
        if ($i40i['BOOST'] > $max_ratio) {
            $max_ratio = $i40i['BOOST'];
        }
    }

    $text_send .= '  ➖ Max Ratio In My Pack: ' . $max_ratio . "\n";
    $text_send .= '  ➖ Participants In My Pack: ' . $participants_num . "\n";
    $text_send .= '  ➖ Accumulated In My Pack: ' . $participants_num  * 10 . ' USDT' . "\n\n";
*/

    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;


} else if ($text == '🔘 Wallet 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [1]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $text_send = '♦️ Your Wallet Address:' . "\n" . '  ➖️' . $user['wallet_address'] . "\n\n";
    $text_send .= 'If you want to submit or change your wallet address, send a new BEP20 address:';
    
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;

   
} else if ($text == '🔘 Support 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $text_send = 'Any technical problem?' . "\n\n" . 'Contact our support through:' . "\n\n" . '@DN_Support' . "\n" . '@DN_Support' . "\n\n";
    $text_send .= urlencode("----------------------------") . "\n" . 'Yours,' . "\n" . 'Anavest Platform' . "\n" . 'Investment Department of ' . urlencode("Ananaki.com");
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;
    
  
} else if ($text == '🔘 Return 🔘' || $text == '🔘 Cancel 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
        
        $telegram->setText('Main menu')->setReplyMarkup($persianmainKeyboard)->sendMessage();

    } else {
        
        $telegram->setText('Main menu')->setReplyMarkup($mainKeyboard)->sendMessage();
    }

    return;

    
} else if ($text == '🇮🇷 فـارسـی 🇮🇷') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['user_lang'], ['Persian']);
    $text_send = '❇️ به پلتفرم آناوست خوش آمدید.' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
    return;               


} else if ($text == '🇬🇧 English 🇬🇧' || $text == '🇨🇳 中国人 🇨🇳' || $text == '🇹🇷 Türkçe 🇹🇷' || $text == '🇸🇦 عــربـي 🇸🇦' || $text == '🇮🇳 हिंदी 🇮🇳' || $text == '🇷🇺 Русский 🇷🇺' || $text == '🇫🇷 Français 🇫🇷') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['user_lang'], ['Engish']);
    $text_send = '❇️ Welcome to the Anavest platform.' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
    return;


} else if ($text == '🎟 سرمایه‌گذاری 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
/*
    if ($user['wallet_address'] == NULL) {
        $text_send = 'ابتدا آدرس کیف پول (BEP20) خود را از طریق منوی "کیف من" ثبت کنید.';
        $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        return;
    }
*/
    $text_send = '⛔️ توجه' . "\n\n";
    $text_send .= '۱) ما دیگر سرمایه‌گذار جدید نمی‌پذیریم.' . "\n\n";
    $text_send .= '۲) در تاریخ ۱۵ آوریل ۲۰۲۴، نصف پول سرمایه‌گذاران قدیمی به توکن آنا تبدیل می‌شود (با قیمت هر توکن ۰.۵ تتر) و نصف مابقی طی چند روز به کیف پولشان عودت داده می‌شود. کاربرانی که قبلاً خودشان توکن آنا خریده‌اند، در محاسبات فوق لحاظ می‌گردند.' . "\n\n";
    $text_send .= '۳) توکن آنا حداقل با قیمت ۱ تتر لانچ خواهد شد اما چه زمانی؟ هر زمان که سرمایه‌گذاران آنا پیچ اینستاگرام آناناکی را تا ۳۰۰ هزار فالور رشد دهند آنگاه توکن لانچ می‌شود. در صورت لانچ، سرمایه کاربران ۱۰ تا ۱۰۰ برابر خواهد شد. ما زمینه را فراهم کردیم حالا نوبت شماست تا با فعالیت خود به سود چند هزار درصدی برسید. پس کمپین تشکیل دهید و هر کاری که لازم است انجام دهید تا پیج رشد کند و توکن لانچ شود.' . "\n\n";
    $text_send .= '۴) چنانچه پیج اینستاگرام رشد نکند توکن لانچ نمی‌شود. در این حالت، شرکت پول افرادی که هر روز برای رشددادن پیج فعالیت کرده‌اند را عودت خواهد داد (فعالیت افراد از کامنت، منشن و به اشتراک‌گذاری پست‌ها ارزیابی می‌شود). ضمناً، توکن آنا سود ماهانه ندارد بلکه سود آن فقط در لانچ‌شدنش می‌باشد.' . "\n\n";
    $text_send .= '۵) پشتیبانان پلتفرم همیشه پاسخگو هستند اما سوالات تکراری و نامرتبط را نادیده می‌گیرند.' . "\n\n";
    $text_send .= 'آدرس پیچ اینستاگرام آناناکی:' . "\n";
    $text_send .= 'https://www.instagram.com/ana.naki?igsh=cWdzdTJ5NGR5cnZh' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();

/*    
} else if ($text == '🎟 واریــــز مبـلغ 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [1]);

    if ($user['DayInv'] > 0) {
        $text_send = '🟢 کاربر گرامی، جهت کاهش ترافیک پلتفرم، هر کاربر می‌تواند روزانه یکبار واریز انجام دهد. برای واریز مبلغ جدید لطفاً تا روز بعد صبر نمایید.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        return;
    }


    $text_send = 'مرحله 1️⃣ ابتدا مبلغی که می‌خواهید سرمایه‌گذاری کنید را به آدرس زیر منتقل کنید. تراکنش باید توسط کیف پول خودتان انجام شود.' . "\n\n";
    $text_send .= '0x' . $base['base_address'] . "\n\n";
    $text_send .= 'مرحله 2️⃣ پس از تایید تراکنش روی بلاکچین، آدرس هش (TxID یا TxHash) آن را همین‌جا به پلتفرم ارسال نمایید.' . "\n\n";
    $text_send .= 'مرحله 3️⃣ حال دکمه "تایید هش من" را بزنید و منتظر دریافت تاییدیه باشید. تاییدیه ممکن است چند ثانیه زمان ببرد.' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($hashKeyboard)->sendMessage();
    

} else if ($text == '🎟 برداشت مبلغ 🎟') {

    $telegram->setText('لطفاً قوانین سرمایه‌گذاری را مطالعه کنید.')->setReplyMarkup($persianmainKeyboard)->sendMessage();

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 1, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['WMonth'] == 0) {
        $text_send = 'کل سرمایه شما: ' . $user['Invested'] . ' تتر' . "\n";
        $text_send .= 'مبلغ قابل‌برداشت: ' . $user['Invested'] . ' تتر' . "\n\n";
        $text_send .= '۱) مبلغ موردنظر برای برداشت را تایپ کنید.' . "\n";
        $text_send .= '۲) با دکمه ارسال، مبلغ را به ربات بفرستید.' . "\n";
        $text_send .= '۳) دکمه "Confirm" را بزنید تا ثبت شود.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($withdrawKeyboard)->sendMessage();
    } else {
        $text_send = '⛔️ فقط یک بار در ماه می‌توانید درخواست برداشت بدهید. لطفاً تا ماه آینده صبر کنید.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($persianinvestmentKeyboard)->sendMessage();
    }

    return;
    

} else if ($text == '🎟 پلن ۴۰ برابری 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $text_send = '❇️ قوانین پلن ۴۰ برابری' . "\n\n";
    $text_send .= '۱) شرح' . "\n";
    $text_send .= 'هر روز، هر کدام از شرکت‌کنندگان ۱۰ تتر پرداخت می‌کنند و پول ۴۰ شرکت‌کننده از طریق قرعه‌کشی به یک نفر پرداخت می‌شود. روزهای بعدی نیز به همین صورت است یعنی شرکت‌کنندگان هر روز ۱۰ تتر پرداخت می‌کنند تا زمانی که برنده شوند. مبلغ شرکت در طرح از موجودی سرمایه‌گذاری کاربر کسر می‌شود و در صورت برنده‌شدن نیز، پاداش به موجودی سرمایه‌گذاری کاربر اضافه می‌شود.' . "\n\n";
    $text_send .= '۲) قرعه‌ها' . "\n";
    $text_send .= 'قرعه‌کشی هر روز انجام می‌شود به شرطی که تعداد شرکت‌کنندگان به حد نصاب برسد در غیر این صورت به فردا موکول می‌گردد. اگر تعداد شرکت‌کنندگان بیشتر از ۴۰ نفر در روز باشد، بیش از یکنفر برنده خواهیم داشت. برای مثال، چنانچه امروز ۷۶ نفر در پلن شرکت کنند، ۲ نفر برنده خواهیم داشت و برای هر کدام ۳۸۰ تتر.' . "\n\n";
    $text_send .= '۳) بوسترها و ضریب شانس' . "\n";
    $text_send .= 'در ابتدا شانس تمامی شرکت‌کنندگان یکسان و برابر با ۱ است. شرکت‌کنندگان می‌توانند شانس خود را از طریق بوسترهای ۱۸ واحدی و ۹۲ واحدی افزایش دهند. ضمناً، به ازای هر رفرالی که در پلن ۴۰ برابری شرکت می‌کند، ۳۶ واحد به شانس معرف اضافه می‌شود. بعلاوه، برای هر روزی که کاربر به شرکت در پلن ادامه می‌دهد (۲ به توان تعداد روزی که شرکت کرده است بعلاوه یک) واحد به شانس برنده‌شدن وی اضافه می‌شود. مثلاً اگر روز پنجم است که شرکت می‌کنید، ۶۴ واحد (معادل ۲ به توان ۶) به ضریب شانس شما اضافه می‌شود. روز ششم، ۱۲۸ واحد دیگر و الی آخر.' . "\n\n";
    $text_send .= '۴) تداوم ضریب شانس' . "\n";
    $text_send .= 'ضریب شانس شرکت‌کنندگان تا زمانی که برنده نشده‌اند، ذخیره می‌شود. وقتی شرکت‌کننده‌ای برنده می‌شود، ضریب شانس وی برای دوره بعدی ریست می‌گردد.' . "\n\n";
    $text_send .= '۵) بهترین حالت و بدترین حالت' . "\n";
    $text_send .= 'بهترین حالت زمانی است که شرکت‌کننده، همان روز اول برنده شده و پولش ۴۰ برابر می‌گردد. اما در بدترین حالت، با توجه به ذخیره‌شدن شانس برای روزهای بعد، انتظار می‌رود شرکت‌کننده با حدود ۵۰% سود برنده شود. پس کاربر نهایتاً در محدوده روزهای ۲۵ و ۲۶ برنده می‌شود منوط به اینکه از بوسترها غفلت نکند زیرا ممکن است سایر شرکت‌کنندگان دائماً از بوسترها استفاده کرده و از وی جلو بیافتند.' . "\n\n";
    $text_send .= urlencode("----------------------------") . "\n" . 'با احترام' . "\n" . 'پلتفرم آناوست'. "\n" . 'دپارتمان سرمایه‌گذاری آناناکی ' . urlencode("Ananaki.com");
    $telegram->setText($text_send)->setReplyMarkup($persianreward40xKeyboard)->sendMessage();
    return;
    
    
} else if ($text == '🎟 ۱۰ تتر به ۴۰۰ تتر 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['P40X'] == 1) {
        $text_send = '✅ شما امروز در این طرح شرکت کرده‌اید. لطفا منتظر نتیجه باشید.' . "\n\n";
        $text_send .= 'اگر برنده شوید، مبلغ به موجودی اصلی شما (یعنی موجودی سرمایه‌گذاری‌شده) اضافه می‌شود.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($persianreward40xKeyboard)->sendMessage();

    } else {
        if ($user['Invested'] >= 10) {
            $db->table('USERS')->where('user_tel_id', $chat_id)->update(['Invested', 'P40X', 'BOOST', 'Paid40', 'Paidall'], [$user['Invested'] - 10, 1, $user['BOOST'] + pow(2, intdiv($user['Paid40'], 10) + 2), $user['Paid40'] + 10, $user['Paidall'] + 10]);
            $active_ref = $db->table('REFERRALS')->where('referral', $chat_id)->first();
            if (!empty($active_ref)) {
                $referrer = $db->table('USERS')->where('user_tel_id', $active_ref['referrer'])->first();
                $db->table('USERS')->where('user_tel_id', $referrer['user_tel_id'])->update(['BOOST'], [$referrer['BOOST'] + 36]);
            }
            $text_send = '✅ شما در 40X با موفقیت شرکت کردید.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($persianreward40xKeyboard)->sendMessage();

        } else {
            $text_send = '⛔️ موجودی شما کافی نیست.' . "\n\n";
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        }
    }
    

} else if ($text == '🔝 افزایش شانس 🔝') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $text_send = '🔝️ بوسترها شانس برنده‌شدن شما را به شدت افزایش می‌دهند. کدام بوستر را می‌خواهید فعال کنید؟' . "\n\n";
    $text_send .= 'این مبلغ از موجودی اصلی شما (یعنی موجودی سرمایه‌گذاری‌شده) کسر می‌شود.' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($persianboosterKeyboard)->sendMessage();


} else if ($text == '🔝 ۱۸ واحد افزایش (۱۲$) 🔝') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['Invested'] >= 12) {
        $db->table('USERS')->where('user_tel_id', $chat_id)->update(['Invested', 'BOOST', 'BUY'], [$user['Invested'] - 12, $user['BOOST'] + 18, $user['BUY'] + 18]);
        $text_send = '✅ شانس شما ۱۸ واحد افزایش یافت.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($persianboosterKeyboard)->sendMessage();
    } else {
        $text_send = '⛔️ موجودی شما کافی نیست.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($persianboosterKeyboard)->sendMessage();
    }


} else if ($text == '🔝 ۹۲ واحد افزایش (۳۰$) 🔝') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    if ($user['Invested'] >= 30) {
        $db->table('USERS')->where('user_tel_id', $chat_id)->update(['Invested', 'BOOST', 'BUY'], [$user['Invested'] - 30, $user['BOOST'] + 92, $user['BUY'] + 30]);
        $text_send = '✅ شانس شما ۹۲ واحد افزایش یافت.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($persianboosterKeyboard)->sendMessage();
    } else {
        $text_send = '⛔️ موجودی شما کافی نیست.' . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($persianboosterKeyboard)->sendMessage();
    }


} else if ($text == '🎟 خرید توکن ANA 🎟') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 1]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $text_send = '❇️ توکن آنـا (ANA)' . "\n\n";
    $text_send .= 'توکن آنا تنها توکن شرکت آناناکی بوده و شامل سهام پروژه‌های اصلی آن (آنابست - پروژه‌های شماره ۳) می‌باشد. این توکن تنها دروازه ورود به اکوسیستم آناناکی است که جایگزین توکن "نکست" شده است.' . "\n\n";
    $text_send .= '➖ شما این هفته می‌توانید ' . $user['Credit'] . ' توکن آنا با قیمت 0.1 تتر خریداری نمایید (قیمت این هفته 0.1 تتر است.' . "\n";
    $text_send .= '➖ موجودی فعلی شما ' . $user['Invested'] . ' تتر معادل ' . round($user['Invested']*10, 2) .  ' آنا می‌باشد (یعنی حداکثر می‌توانید این تعداد با این قیمت بخرید مگر اینکه موجودی خود را با واریز تتر افزایش دهید).' . "\n\n";
    $text_send .= '🔹 چگونه توکن آنا بخرم؟' . "\n";
    $text_send .= '۱) ابتدا تعداد توکن که می‌خواهید را تایپ کرده و با دکمه ارسال به ربات بفرستید. برای مثال، اگر به اندازه ۲۰۰ تتر می‌خواهید توکن آنا بخرید، مقدار ۲۰۰۰ را تایپ و ارسال نمایید.' . "\n";
    $text_send .= '۲) سپس دکمه "Buy Now" را بزنید و منتظر دریافت تاییدیه از طرف ربات بمانید.' . "\n\n";
    $text_send .= urlencode("----------------------------") . "\n" . 'با احترام' . "\n" . 'پلتفرم آناوست'. "\n" . 'دپارتمان سرمایه‌گذاری آناناکی ' . urlencode("Ananaki.com");
    $telegram->setText($text_send)->setReplyMarkup($persianbuyANAKeyboard)->sendMessage();
    return;
    
    
} else if ($text == '◾️ لغو عملیات ◾️') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $telegram->setText('لغو عملیات')->setReplyMarkup($persianreward40xKeyboard)->sendMessage();


} else if ($text == '🧑 دعوت از دوستان 🧑') {
    
    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check', 'wiw_check', 'ana_check'], [0, 0, 0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();
    $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->update(['part_flag'], [0]);
    $deposit_hash = $db->table('DEPOSITS')->where('user_tel_id', $user['user_tel_id'])->where('run_day', $base['run_day'])->first();

    $text_send = '🎟 پلتفرم سرمایه‌گذاری آناوست' . "\n\n";
    $text_send .= 'لینک اختصاصی شما برای دعوت از دوستان:' . "\n\n";
    $text_send .= 'https://t.me/anavestbot?start=' . $chat_id . "\n\n";
    $text_send .= urlencode("----------------------------") . "\n" . 'با احترام' . "\n" . 'پلتفرم آناوست'. "\n" . 'دپارتمان سرمایه‌گذاری آناناکی ' . urlencode("Ananaki.com");
    $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
    return;

*/    
} else if ($text == '🔘 آمار من 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $text_send .= '♦️ شماره آیدی تلگرام من:' . "\n" . '  ➖️' . $user['user_tel_id'] . "\n\n";

    $text_send .= '🏆 وضعیت سرمایه‌گذاری من:' . "\n";
    $text_send .= '  ➖ سرمایه تتری من: ' . $user['Invested'] . ' تتر' . "\n";
    $text_send .= '  ➖ تعداد توکن من: ' . $user['ANA'] . ' آنا' . "\n";
/*
    $text_send .= '🏆 وضعیت پلن ۴۰ برابری من:' . "\n";
    $text_send .= '  ➖ مرحله در حال اجرا: ' . $user['Step40'] . "\n";
    $text_send .= '  ➖ دفعاتی که برنده شده‌ام: ' . $user['W40X'] . "\n";
    $text_send .= '  ➖ امروز شرکت کرده‌ام: ' . $user['P40X'] . "\n";
    $text_send .= '  ➖ پرداختی من این مرحله: ' . $user['Paid40'] . ' تتر' . "\n";
    $text_send .= '  ➖ پرداختی من تاکنون: ' . $user['Paidall'] . ' تتر' . "\n";
    $text_send .= '  ➖ دریافتی من تاکنون: ' . $user['Gain40'] . ' تتر' . "\n";
    $text_send .= '  ➖ ضریب شانس من در بسته‌ای که هستم: ' . $user['BOOST'] . "\n";

    $i40info = $db->table('USERS')->where('P40X', 1)->get('*');
    $participants_num = count($i40info);
    $max_ratio = 0;

    foreach($i40info as $i40i) {
        if ($i40i['BOOST'] > $max_ratio) {
            $max_ratio = $i40i['BOOST'];
        }
    }

    $text_send .= '  ➖ بیشترین ضریب شانس در بسته من: ' . $max_ratio . "\n";
    $text_send .= '  ➖ تعداد شرکت‌کنندگان در بسته من: ' . $participants_num . "\n";
    $text_send .= '  ➖ پول جمع‌شده در این بسته: ' . $participants_num  * 10 . ' تتر' . "\n\n";
*/

    $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
    return;

} else if ($text == '🔘 کیف من 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [1]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $text_send = '♦️ آدرس کیف پول من:' . "\n" . '  ➖️' . $user['wallet_address'] . "\n\n";
    $text_send .= 'اگر می‌خواهید آدرس کیف پول خود را ارسال یا تغییر دهید، یک آدرس BEP20 جدید ارسال کنید.';
    $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
    return;


} else if ($text == '🔘 پشتیبانی 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $text_send = 'آیا مشکل فنی دارید؟' . "\n\n" . 'به آیدی پشتیبانی پیام دهید 👇' . "\n\n" . '@DN_Support' . "\n" . '@DN_Support' . "\n\n";
    $text_send .= urlencode("----------------------------") . "\n" . 'با احترام' . "\n" . 'پلتفرم آناوست'. "\n" . 'دپارتمان سرمایه‌گذاری آناناکی ' . urlencode("Ananaki.com");
    $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
    return;


} else if ($text == '🔘 زبان پلتفرم 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $text_send = 'زبان مورد نظرتان را انتخاب کنید.' . "\n\n";
    $telegram->setText($text_send)->setReplyMarkup($langKeyboard)->sendMessage();
    return;
    
} else if ($text == '🔘 بازگشت 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $telegram->setText('منوی اصلی')->setReplyMarkup($persianmainKeyboard)->sendMessage();
    return;
    
} else if ($text == '🔘 لغو عملیات 🔘') {

    $db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_check'], [0]);
    $user = $db->table('USERS')->where('user_tel_id', $chat_id)->first();

    $telegram->setText('لغو عملیات...')->setReplyMarkup($persianmainKeyboard)->sendMessage();
    return;
    
}


if ($user['wallet_check'] == 1 && $user['is_admin'] == 0) {

    if (str_starts_with($text, '0x')) {

        if ($db->table('USERS')->where('user_tel_id', $chat_id)->update(['wallet_address', 'wallet_check'], [$text, 0]) != false) {
            if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
                $text_send = '✅ آدرس کیف پول شما ذخیره شد.';
                $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
            } else {
                $text_send = '✅ Your wallet address saved.';
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
        } else {
            if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
                $text_send = '⛔️ آدرس کیف پول تکراری است!';
                $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
            } else {
                $text_send = '⛔️ Duplicated wallet address!';
                $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
            }
        }
                
    } else {
        if ($user['user_lang'] == 'Persian' || $user['user_lang'] == NULL) {
            $text_send = '⛔️ آدرس کیف پول اشتباه است!';
            $telegram->setText($text_send)->setReplyMarkup($persianmainKeyboard)->sendMessage();
        } else {
        $text_send = '⛔️ Your wallet address is wrong! The BEP20 address starts with "0x..."';
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage();
        }
    }
}



// Admin Section

if ($user['is_admin']) {

    if ($text == 'Total Asset') {

        $totalasset = 0;
        $tasset = $db->table('USERS')->Where(1, 1)->get('*');
        foreach($tasset as $ta) {
            $totalasset = $totalasset + $ta['Invested'];
        }
        $text_send = 'Total Asset = $' . $totalasset . "\n\n";
        $telegram->setText($text_send)->setReplyMarkup($mainKeyboard_admin)->sendMessage();
        return;


    } else if ($text == 'Robot ON/OFF') {

        if ($base['is_bot_on'] == 0) {
            $db->table('BASEDATA')->where('id', 1)->update(['is_bot_on'], [1]);
            $telegram->setText('Robot ON')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
        } else {
            $db->table('BASEDATA')->where('id', 1)->update(['is_bot_on'], [0]);
            $telegram->setText('Robot OFF')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
        }
        return;

    } else if ($text == 'MSG ON/OFF') {

        if ($base['send_msg'] == 0) {
            $db->table('BASEDATA')->where('id', 1)->update(['send_msg'], [1]);
            $telegram->setText('Message ON')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
        } else {
            $db->table('BASEDATA')->where('id', 1)->update(['send_msg'], [0]);
            $telegram->setText('Message OFF')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
        }
        return;
        
    } else if ($text == 'Send Message' && $base['send_msg'] == 1) {

        $total_users = $db->table('USERS')->get('*');
/*
        $text_send = '⛔️ Attention:' . "\n\n";
        $text_send .= '1) We no longer accept new investors.' . "\n\n";
        $text_send .= '2) On April 15, 2024, half of the old investors money will be converted into ANA tokens (with a price of $0.5 per token) and the remaining half will be returned to their wallets within a few days. Users who have already bought ANA tokens themselves are included in the above calculations.' . "\n\n";
        $text_send .= '3) ANA will be launched at least at the price of 1 USDT, but when? Whenever investors grow the Ananaki Instagram page to 300,000 followers, then the token will be launched. In case of launch, users capital will increase 10 to 100 times. We have prepared the ground, now it is your turn to achieve several thousand percent profit with your activity. So create a campaign and do whatever it takes to grow the page and launch the token.' . "\n\n";
        $text_send .= '4) If the Instagram page does not grow, the token will not be launched. In this case, the company will return the money of those who have worked to grow the page every day (their activity is determined by comments, mentions and sharing of posts). In addition, ANA does not have a monthly profit, but its profit is only at its launch.' . "\n\n";
        $text_send .= '5) Supporters of the platform are always responsive but they ignore repetitive and irrelevant questions.' . "\n\n";
        $text_send .= 'Ananaki Instagram address:' . "\n";
        $text_send .= 'https://www.instagram.com/ana.naki?igsh=cWdzdTJ5NGR5cnZh' . "\n\n";
        $text_send .= '⛔️ توجه' . "\n";
        $text_send .= '۱) ما دیگر سرمایه‌گذار جدید نمی‌پذیریم.' . "\n\n";
        $text_send .= '۲) در تاریخ ۱۵ آوریل ۲۰۲۴، نصف پول سرمایه‌گذاران قدیمی به توکن آنا تبدیل می‌شود (با قیمت هر توکن ۰.۵ تتر) و نصف مابقی طی چند روز به کیف پولشان عودت داده می‌شود. کاربرانی که قبلاً خودشان توکن آنا خریده‌اند، در محاسبات فوق لحاظ می‌گردند.' . "\n\n";
        $text_send .= '۳) توکن آنا حداقل با قیمت ۱ تتر لانچ خواهد شد اما چه زمانی؟ هر زمان که سرمایه‌گذاران آنا پیچ اینستاگرام آناناکی را تا ۳۰۰ هزار فالور رشد دهند آنگاه توکن لانچ می‌شود. در صورت لانچ، سرمایه کاربران ۱۰ تا ۱۰۰ برابر خواهد شد. ما زمینه را فراهم کردیم حالا نوبت شماست تا با فعالیت خود به سود چند هزار درصدی برسید. پس کمپین تشکیل دهید و هر کاری که لازم است انجام دهید تا پیج رشد کند و توکن لانچ شود.' . "\n\n";
        $text_send .= '۴) چنانچه پیج اینستاگرام رشد نکند توکن لانچ نمی‌شود. در این حالت، شرکت پول افرادی که هر روز برای رشددادن پیج فعالیت کرده‌اند را عودت خواهد داد (فعالیت افراد از کامنت، منشن و به اشتراک‌گذاری پست‌ها ارزیابی می‌شود). ضمناً، توکن آنا سود ماهانه ندارد بلکه سود آن فقط در لانچ‌شدنش می‌باشد.' . "\n\n";
        $text_send .= '۵) پشتیبانان پلتفرم همیشه پاسخگو هستند اما سوالات تکراری و نامرتبط را نادیده می‌گیرند.' . "\n\n";
        $text_send .= 'آدرس پیچ اینستاگرام آناناکی:' . "\n";
        $text_send .= 'https://www.instagram.com/ana.naki?igsh=cWdzdTJ5NGR5cnZh' . "\n\n";
*/

        $text_send = 'Users information, including the number of ANA tokens and their wallet address, is stored in our database. At the time of token launch, we will create a new bot. Until then, our Instagram page is active.' . "\n\n";
        $text_send .= 'اطلاعات کاربران شامل تعداد توکن‌های آنا و آدرس کیف پول آنها در دیتابیس ما ذخیره شده است. در زمان لانچ توکن، یک ربات جدید ایجاد خواهیم کرد. تا آن زمان، پیج اینستاگرام ما فعال می‌باشد.' . "\n\n";

        foreach($total_users as $tus) {
            $telegram->setText($text_send)->setReplyMarkup($mainKeyboard)->sendMessage($tus['user_tel_id']);
        }

        $db->table('BASEDATA')->where('id', 1)->update(['send_msg'], [0]);
        $telegram->setText('Done.')->setReplyMarkup($mainKeyboard_admin)->sendMessage();
        return;
    }
//    $telegram->setText($content)->setReplyMarkup($mainKeyboard_admin)->sendMessage();
    
}