<?php

require_once('config.php');
require_once('telegram_json.php');
require_once('Classes/DBConnection.php');
require_once('Classes/DB.php');
require_once('Classes/TelegramService.php');
require_once('Classes/Telegram.php');
require_once('helper.php');

header('Clear-Site-Data: "cache", "cookies", "storage", "executionContexts"');

use Classes\DB;
use Classes\Telegram;


global $db;
global $telegram;
global $chat_id;
global $user;
global $base;
global $stream;
global $poster;
global $stm_user;


$db = new DB();
$telegram = new Telegram();

$chat_id = $_GET['chat_id'];
$stream = $db->table('STREAMS')->where('id', 1)->first();

$base = $db->table('BASE')->where('id', 1)->first();
$user = $db->table('USERS')->where('telegramID', $chat_id)->first();
$stream = $db->table('STREAMS')->where('running_stream', $base['running_stream'])->first();
$poster = $db->table('POSTERS')->where('id', 1)->first();
$stm_user = $db->table('STM_USER')->where('telegramID', $chat_id)->first();
$rank = $db->table('RANK')->where('telegramID', $chat_id)->first();

?>



<!DOCTYPE html>

<html lang="en-US">

    <head>
        <meta charset="utf-8">
        <script src="https://telegram.org/js/telegram-web-app.js"></script>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Yazak</title>
        <link rel="stylesheet" href="style.css">
    </head>

    <body>
        
        <div class="loading">
            
            <img class="loading-photo" src="https://streamres.com/stream/images/Stream-landing.png">
            
            <div class="devider"></div>
            <div class="devider"></div>
            <div class="devider"></div>
            <div class="devider"></div>
            <div class="devider"></div>
            <div class="devider"></div>
            <div class="devider"></div>
            <div class="devider"></div>
            
            <p class="loading-account-validate">Securing Application</p>

            <div class="devider"></div>

            <div class="loading-bars">
                <span></span>
                <span></span>
                <span></span>
                <span></span>
                <span></span>
            </div>
            
        </div>

        <div class="content">
            
            <div class="navigation">
                <ul>
                    <li class="list active">
                        <button type="button" id="button-page1">
                            <span class="icon"><ion-icon name="apps"></ion-icon></span>
                            <span class="text">Streams</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page2">
                            <span class="icon"><ion-icon name="albums"></ion-icon></span>
                            <span class="text">Posters</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page3">
                            <span class="icon"><ion-icon name="logo-buffer"></ion-icon></span>
                            <span class="text">Products</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page4">
                            <span class="icon"><ion-icon name="cube"></ion-icon></span>
                            <span class="text">Synergy</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page5">
                            <span class="icon"><ion-icon name="book"></ion-icon></span>
                            <span class="text">Overview</span>
                        </button>
                    </li>
                </ul>
            </div>


            <div class="header">
                <div class="header-app">
                    <img class="header-app-logo" src="https://streamres.com/stream/images/logo.png">
                </div>
                <div class="header-gift-box">
                    <span class="header-gift-icon" onclick="showGiftPopup()"><ion-icon name="gift"></ion-icon></span>
                    <span class="header-gift-icon-active" onclick="showGiftActivePopup()"><ion-icon name="gift"></ion-icon></span>
                </div>
                <div class="header-userpoints-box">
                    <img class="header-userpoints-icon" src="https://streamres.com/stream/images/points_icon.png">
                    <p class="header-userpoints-number"><?php echo(number_format($user['points'])); ?></p>
                </div>
            </div>

            <div class="gift-popup">
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
                <img class="gift-popup-icon" src="https://streamres.com/stream/images/gift-popup.png">
                <p class="gift-popup-title">D R A W S</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <p class="gift-popup-subject">Lambo + iPhone</p>
                <p class="gift-popup-date">Date to be announced soon</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <p class="gift-popup-desc">Get ready for big and amazing periodic raffles of lambos and iPhones. The raffles and conditions of participation will be announced soon.</p>
                <div class="devider"></div>
                <p class="gift-popup-desc">Also, all draws are conducted live through our social networks in a friendly but competitive atmosphere. So, as much as you can, increase your score within the application in various ways, including inviting friends. Good Luck Buddies!</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
                <button class="gift-joinTG-btn" onclick="joinTG()">Latest News</button>
                <button class="gift-popup-btn" onclick="closeGiftPopup()">Close</button>
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
            </div>
            <div class="gift-active-popup">
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
                <img class="gift-popup-icon" src="https://streamres.com/stream/images/gift-popup.png">
                <p class="gift-popup-title">D R A W S</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <p class="gift-popup-subject">Lambo + iPhone</p>
                <p class="gift-popup-date">Lottery Date: 30 NOV 2024</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <p class="gift-popup-desc">Get ready for big and amazing periodic raffles of lambos and iPhones. The raffles and conditions of participation will be announced soon.</p>
                <div class="devider"></div>
                <p class="gift-popup-desc">Also, all draws are conducted live through our social networks in a friendly but competitive atmosphere. So, as much as you can, increase your score within the application in various ways, including inviting friends. Good Luck Streamers!</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
                <button class="gift-joinTG-btn" onclick="joinTG()">Latest News</button>
                <button class="gift-active-popup-btn" onclick="closeGiftActivePopup()">Close</button>
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
            </div>
            <!--
            <div class="x3-popup">
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
                <img class="x3-popup-icon" src="https://streamres.com/stream/images/x3.png">
                <p class="x8-popup-title">M U L T I P L I E R</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <p class="x8-popup-subject">THE WINNER SIDE</p>
                <p class="x8-popup-date">Date: End of each stream</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <p class="x8-popup-desc">Voters (i.e. fans) of winner side will receive 3 times more airdrops. However, this fact should not make you fanatical, as we suggest you vote according to your true belief. Good Luck Streamers!</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
                <button class="x8-popup-btn" onclick="closeX3Popup()">Close</button>
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
            </div>
            -->
            <div class="x8-popup">
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
                <img class="x8-popup-icon" src="https://streamres.com/stream/images/x8.png">
                <p class="x8-popup-title">M U L T I P L I E R</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <p class="x8-popup-subject">MOST LIKED POSTER</p>
                <p class="x8-popup-date">Date: Before NFT Conversion</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <p class="x8-popup-desc">Each poster that gets the most likes will bring more airdrop points for its fans, meaning that voters (i.e. likers) of the mentioned poster will receive 8 times more airdrops. Good Luck Streamers!</p>
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
                <button class="x8-popup-btn" onclick="closeX8Popup()">Close</button>
                <div class="devider"></div>
                <div class="devider"></div>
                <div class="devider"></div>
            </div>






            <div class="pages-section"> <!-- Pages -->


                <div class="page1"> <!-- Streams -->

                    <img class="stream-page-photo" src="https://streamres.com/stream/images/streampage-photo.png">
                    <p class="stream-title">S T R E A M S</p>
                    
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    
                    <div class="stream-frame">
                        
                        <div class="stream-name-box">
                            <p class="stream-name"><?php echo($stream['stream_name']); ?></p>
                            <!-- <img class="posters-x3-icon" src="https://streamres.com/stream/images/x3.png" onclick="showX3Popup()"> -->
                        </div>
                        <p class="stream-question"><?php echo($stream['stream_question']); ?></p>

                        <div class="stream-cards-frame">
                            
                            <div class="stmcards">
                                <img class="stmcards-image" src="https://streamres.com/stream/images/men-photo.png">
                                <div class="line-dashed"></div>
                                <p class="stmcards-desc">MEN</p>
                                <div class="line-dashed"></div>
                                <div class="line-transparent"></div>
                                <div class="stmcards-votebox">
                                    <img class="stmcards-votebox-icon" src="https://streamres.com/stream/images/votes-icon.png">
                                    <p class="stmcards-votebox-votes" id="stream01-votes-num"><?php echo(number_format($stream['item01'])); ?></p>
                                </div>
                                <button type="button" class="stmcards-vote-btn" id="stream01-vote-btn" onclick="voteStreamItem01()">Vote For This</button>
                                <?php 
                                    if ($user['stream_daily_vote'] < 1) {
                                ?>
                                        <script>
                                            var card1_voteBtn = document.getElementById('stream01-vote-btn');
                                            card1_voteBtn.disabled = true;
                                            card1_voteBtn.style.backgroundColor = "#212A33";
                                            card1_voteBtn.innerHTML  = "Next time random";
                                        </script>
                                <?php
                                    } else {
                                ?>
                                        <script>
                                            var card1_voteBtn = document.getElementById('stream01-vote-btn');
                                            card1_voteBtn.disabled = false;
                                            card1_voteBtn.style.backgroundColor = "#248BDA";
                                        </script>
                                <?php
                                    }
                                ?>
                            </div>
                            
                            <div class="stmcards">
                                <img class="stmcards-image" src="https://streamres.com/stream/images/women-photo.png">
                                <div class="line-dashed"></div>
                                <p class="stmcards-desc">WOMEN</p>
                                <div class="line-dashed"></div>
                                <div class="line-transparent"></div>
                                <div class="stmcards-votebox">
                                    <img class="stmcards-votebox-icon" src="https://streamres.com/stream/images/votes-icon.png">
                                    <p class="stmcards-votebox-votes" id="stream02-votes-num"><?php echo(number_format($stream['item02'])); ?></p>
                                </div>
                                <button type="button" class="stmcards-vote-btn" id="stream02-vote-btn" onclick="voteStreamItem02()">Vote For This</button>
                                <?php 
                                    if ($user['stream_daily_vote'] < 1) {
                                ?>
                                        <script>
                                            var card2_voteBtn = document.getElementById('stream02-vote-btn');
                                            card2_voteBtn.disabled = true;
                                            card2_voteBtn.style.backgroundColor = "#212A33";
                                            card2_voteBtn.innerHTML  = "Next time random";
                                        </script>
                                <?php
                                    } else {
                                ?>
                                        <script>
                                            var card2_voteBtn = document.getElementById('stream02-vote-btn');
                                            card2_voteBtn.disabled = false;
                                            card2_voteBtn.style.backgroundColor = "#248BDA";
                                        </script>
                                <?php
                                    }
                                ?>
                            </div>
                            
                        </div>
                        
                        <div class="devider"></div>
                        <div class="devider"></div>
                        
                        <p class="whatisstream-title">What is a stream?</p>
                        <p class="whatisstream-desc">Each stream is a marketing research backed by companies, brands or research institutes. You get points for participating in streams. Considering that the duration of each stream is limited, so make the most of these opportunities.</p>
                        
                        <div class="devider"></div>
                        <div class="devider"></div>
                    </div>

                    <div class="page-finish-devider"></div>
                    
                </div>






                <div class="page2"> <!-- Posters -->

                    <img class="posters-page-photo" src="https://streamres.com/stream/images/poster-icon.png">
                    <p class="posters-title">P O S T E R S</p>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="posters-name-box">
                        <p class="posters-name">DEFINITION OF NATIONS</p>
                        <img class="posters-x8-icon" src="https://streamres.com/stream/images/x8.png" onclick="showX8Popup()">
                    </div>
                    <p class="posters-question">According to your belief, like the following posters based on the validity of their content. No bias please.</p>

                    <div class="posters-frame">
                        
                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Australia.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster01-votes-num"><?php echo(number_format($poster['item01'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster01-vote-btn" onclick="votePosterItem01()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster01_voteBtn = document.getElementById('poster01-vote-btn');
                                        poster01_voteBtn.disabled = true;
                                        poster01_voteBtn.style.backgroundColor = "#212A33";
                                        poster01_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster01_voteBtn = document.getElementById('poster01-vote-btn');
                                        poster01_voteBtn.disabled = false;
                                        poster01_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Belgium.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster02-votes-num"><?php echo(number_format($poster['item02'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster02-vote-btn" onclick="votePosterItem02()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster02_voteBtn = document.getElementById('poster02-vote-btn');
                                        poster02_voteBtn.disabled = true;
                                        poster02_voteBtn.style.backgroundColor = "#212A33";
                                        poster02_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster02_voteBtn = document.getElementById('poster02-vote-btn');
                                        poster02_voteBtn.disabled = false;
                                        poster02_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Brazil.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster03-votes-num"><?php echo(number_format($poster['item03'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster03-vote-btn" onclick="votePosterItem03()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster03_voteBtn = document.getElementById('poster03-vote-btn');
                                        poster03_voteBtn.disabled = true;
                                        poster03_voteBtn.style.backgroundColor = "#212A33";
                                        poster03_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster03_voteBtn = document.getElementById('poster03-vote-btn');
                                        poster03_voteBtn.disabled = false;
                                        poster03_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Canada.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster04-votes-num"><?php echo(number_format($poster['item04'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster04-vote-btn" onclick="votePosterItem04()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster04_voteBtn = document.getElementById('poster04-vote-btn');
                                        poster04_voteBtn.disabled = true;
                                        poster04_voteBtn.style.backgroundColor = "#212A33";
                                        poster04_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster04_voteBtn = document.getElementById('poster04-vote-btn');
                                        poster04_voteBtn.disabled = false;
                                        poster04_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/China.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster05-votes-num"><?php echo(number_format($poster['item05'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster05-vote-btn" onclick="votePosterItem05()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster05_voteBtn = document.getElementById('poster05-vote-btn');
                                        poster05_voteBtn.disabled = true;
                                        poster05_voteBtn.style.backgroundColor = "#212A33";
                                        poster05_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster05_voteBtn = document.getElementById('poster05-vote-btn');
                                        poster05_voteBtn.disabled = false;
                                        poster05_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Egypt.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster06-votes-num"><?php echo(number_format($poster['item06'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster06-vote-btn" onclick="votePosterItem06()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster06_voteBtn = document.getElementById('poster06-vote-btn');
                                        poster06_voteBtn.disabled = true;
                                        poster06_voteBtn.style.backgroundColor = "#212A33";
                                        poster06_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster06_voteBtn = document.getElementById('poster06-vote-btn');
                                        poster06_voteBtn.disabled = false;
                                        poster06_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/England.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster07-votes-num"><?php echo(number_format($poster['item07'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster07-vote-btn" onclick="votePosterItem07()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster07_voteBtn = document.getElementById('poster07-vote-btn');
                                        poster07_voteBtn.disabled = true;
                                        poster07_voteBtn.style.backgroundColor = "#212A33";
                                        poster07_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster07_voteBtn = document.getElementById('poster07-vote-btn');
                                        poster07_voteBtn.disabled = false;
                                        poster07_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Finland.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster08-votes-num"><?php echo(number_format($poster['item08'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster08-vote-btn" onclick="votePosterItem08()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster08_voteBtn = document.getElementById('poster08-vote-btn');
                                        poster08_voteBtn.disabled = true;
                                        poster08_voteBtn.style.backgroundColor = "#212A33";
                                        poster08_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster08_voteBtn = document.getElementById('poster08-vote-btn');
                                        poster08_voteBtn.disabled = false;
                                        poster08_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/France.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster09-votes-num"><?php echo(number_format($poster['item09'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster09-vote-btn" onclick="votePosterItem09()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster09_voteBtn = document.getElementById('poster09-vote-btn');
                                        poster09_voteBtn.disabled = true;
                                        poster09_voteBtn.style.backgroundColor = "#212A33";
                                        poster09_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster09_voteBtn = document.getElementById('poster09-vote-btn');
                                        poster09_voteBtn.disabled = false;
                                        poster09_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Germany.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster10-votes-num"><?php echo(number_format($poster['item10'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster10-vote-btn" onclick="votePosterItem10()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster10_voteBtn = document.getElementById('poster10-vote-btn');
                                        poster10_voteBtn.disabled = true;
                                        poster10_voteBtn.style.backgroundColor = "#212A33";
                                        poster10_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster10_voteBtn = document.getElementById('poster10-vote-btn');
                                        poster10_voteBtn.disabled = false;
                                        poster10_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/India.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster11-votes-num"><?php echo(number_format($poster['item11'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster11-vote-btn" onclick="votePosterItem11()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster11_voteBtn = document.getElementById('poster11-vote-btn');
                                        poster11_voteBtn.disabled = true;
                                        poster11_voteBtn.style.backgroundColor = "#212A33";
                                        poster11_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster11_voteBtn = document.getElementById('poster11-vote-btn');
                                        poster11_voteBtn.disabled = false;
                                        poster11_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Indonesia.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster12-votes-num"><?php echo(number_format($poster['item12'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster12-vote-btn" onclick="votePosterItem12()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster12_voteBtn = document.getElementById('poster12-vote-btn');
                                        poster12_voteBtn.disabled = true;
                                        poster12_voteBtn.style.backgroundColor = "#212A33";
                                        poster12_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster12_voteBtn = document.getElementById('poster12-vote-btn');
                                        poster12_voteBtn.disabled = false;
                                        poster12_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Iran.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster13-votes-num"><?php echo(number_format($poster['item13'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster13-vote-btn" onclick="votePosterItem13()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster13_voteBtn = document.getElementById('poster13-vote-btn');
                                        poster13_voteBtn.disabled = true;
                                        poster13_voteBtn.style.backgroundColor = "#212A33";
                                        poster13_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster13_voteBtn = document.getElementById('poster13-vote-btn');
                                        poster13_voteBtn.disabled = false;
                                        poster13_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Italy.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster14-votes-num"><?php echo(number_format($poster['item14'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster14-vote-btn" onclick="votePosterItem14()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster14_voteBtn = document.getElementById('poster14-vote-btn');
                                        poster14_voteBtn.disabled = true;
                                        poster14_voteBtn.style.backgroundColor = "#212A33";
                                        poster14_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster14_voteBtn = document.getElementById('poster14-vote-btn');
                                        poster14_voteBtn.disabled = false;
                                        poster14_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Japan.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster15-votes-num"><?php echo(number_format($poster['item15'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster15-vote-btn" onclick="votePosterItem15()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster15_voteBtn = document.getElementById('poster15-vote-btn');
                                        poster15_voteBtn.disabled = true;
                                        poster15_voteBtn.style.backgroundColor = "#212A33";
                                        poster15_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster15_voteBtn = document.getElementById('poster15-vote-btn');
                                        poster15_voteBtn.disabled = false;
                                        poster15_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Korea.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster16-votes-num"><?php echo(number_format($poster['item16'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster16-vote-btn" onclick="votePosterItem16()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster16_voteBtn = document.getElementById('poster16-vote-btn');
                                        poster16_voteBtn.disabled = true;
                                        poster16_voteBtn.style.backgroundColor = "#212A33";
                                        poster16_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster16_voteBtn = document.getElementById('poster16-vote-btn');
                                        poster16_voteBtn.disabled = false;
                                        poster16_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Mexico.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster17-votes-num"><?php echo(number_format($poster['item17'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster17-vote-btn" onclick="votePosterItem17()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster17_voteBtn = document.getElementById('poster17-vote-btn');
                                        poster17_voteBtn.disabled = true;
                                        poster17_voteBtn.style.backgroundColor = "#212A33";
                                        poster17_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster17_voteBtn = document.getElementById('poster17-vote-btn');
                                        poster17_voteBtn.disabled = false;
                                        poster17_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Poland.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster18-votes-num"><?php echo(number_format($poster['item18'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster18-vote-btn" onclick="votePosterItem18()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster18_voteBtn = document.getElementById('poster18-vote-btn');
                                        poster18_voteBtn.disabled = true;
                                        poster18_voteBtn.style.backgroundColor = "#212A33";
                                        poster18_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster18_voteBtn = document.getElementById('poster18-vote-btn');
                                        poster18_voteBtn.disabled = false;
                                        poster18_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Portugal.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster19-votes-num"><?php echo(number_format($poster['item19'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster19-vote-btn" onclick="votePosterItem19()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster19_voteBtn = document.getElementById('poster19-vote-btn');
                                        poster19_voteBtn.disabled = true;
                                        poster19_voteBtn.style.backgroundColor = "#212A33";
                                        poster19_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster19_voteBtn = document.getElementById('poster19-vote-btn');
                                        poster19_voteBtn.disabled = false;
                                        poster19_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Russia.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster20-votes-num"><?php echo(number_format($poster['item20'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster20-vote-btn" onclick="votePosterItem20()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster20_voteBtn = document.getElementById('poster20-vote-btn');
                                        poster20_voteBtn.disabled = true;
                                        poster20_voteBtn.style.backgroundColor = "#212A33";
                                        poster20_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster20_voteBtn = document.getElementById('poster20-vote-btn');
                                        poster20_voteBtn.disabled = false;
                                        poster20_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/S-Arabia.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster21-votes-num"><?php echo(number_format($poster['item21'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster21-vote-btn" onclick="votePosterItem21()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster21_voteBtn = document.getElementById('poster21-vote-btn');
                                        poster21_voteBtn.disabled = true;
                                        poster21_voteBtn.style.backgroundColor = "#212A33";
                                        poster21_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster21_voteBtn = document.getElementById('poster21-vote-btn');
                                        poster21_voteBtn.disabled = false;
                                        poster21_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Spain.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster22-votes-num"><?php echo(number_format($poster['item22'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster22-vote-btn" onclick="votePosterItem22()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster22_voteBtn = document.getElementById('poster22-vote-btn');
                                        poster22_voteBtn.disabled = true;
                                        poster22_voteBtn.style.backgroundColor = "#212A33";
                                        poster22_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster22_voteBtn = document.getElementById('poster22-vote-btn');
                                        poster22_voteBtn.disabled = false;
                                        poster22_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Sweden.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster23-votes-num"><?php echo(number_format($poster['item23'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster23-vote-btn" onclick="votePosterItem23()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster23_voteBtn = document.getElementById('poster23-vote-btn');
                                        poster23_voteBtn.disabled = true;
                                        poster23_voteBtn.style.backgroundColor = "#212A33";
                                        poster23_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster23_voteBtn = document.getElementById('poster23-vote-btn');
                                        poster23_voteBtn.disabled = false;
                                        poster23_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Swiss.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster24-votes-num"><?php echo(number_format($poster['item24'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster24-vote-btn" onclick="votePosterItem24()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster24_voteBtn = document.getElementById('poster24-vote-btn');
                                        poster24_voteBtn.disabled = true;
                                        poster24_voteBtn.style.backgroundColor = "#212A33";
                                        poster24_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster24_voteBtn = document.getElementById('poster24-vote-btn');
                                        poster24_voteBtn.disabled = false;
                                        poster24_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Taiwan.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster25-votes-num"><?php echo(number_format($poster['item25'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster25-vote-btn" onclick="votePosterItem25()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster25_voteBtn = document.getElementById('poster25-vote-btn');
                                        poster25_voteBtn.disabled = true;
                                        poster25_voteBtn.style.backgroundColor = "#212A33";
                                        poster25_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster25_voteBtn = document.getElementById('poster25-vote-btn');
                                        poster25_voteBtn.disabled = false;
                                        poster25_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Turkey.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster26-votes-num"><?php echo(number_format($poster['item26'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster26-vote-btn" onclick="votePosterItem26()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster26_voteBtn = document.getElementById('poster26-vote-btn');
                                        poster26_voteBtn.disabled = true;
                                        poster26_voteBtn.style.backgroundColor = "#212A33";
                                        poster26_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster26_voteBtn = document.getElementById('poster26-vote-btn');
                                        poster26_voteBtn.disabled = false;
                                        poster26_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/UAE.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster27-votes-num"><?php echo(number_format($poster['item27'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster27-vote-btn" onclick="votePosterItem27()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster27_voteBtn = document.getElementById('poster27-vote-btn');
                                        poster27_voteBtn.disabled = true;
                                        poster27_voteBtn.style.backgroundColor = "#212A33";
                                        poster27_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster27_voteBtn = document.getElementById('poster27-vote-btn');
                                        poster27_voteBtn.disabled = false;
                                        poster27_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Ukraine.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster28-votes-num"><?php echo(number_format($poster['item28'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster28-vote-btn" onclick="votePosterItem28()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster28_voteBtn = document.getElementById('poster28-vote-btn');
                                        poster28_voteBtn.disabled = true;
                                        poster28_voteBtn.style.backgroundColor = "#212A33";
                                        poster28_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster28_voteBtn = document.getElementById('poster28-vote-btn');
                                        poster28_voteBtn.disabled = false;
                                        poster28_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/USA.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster29-votes-num"><?php echo(number_format($poster['item29'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster29-vote-btn" onclick="votePosterItem29()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster29_voteBtn = document.getElementById('poster29-vote-btn');
                                        poster29_voteBtn.disabled = true;
                                        poster29_voteBtn.style.backgroundColor = "#212A33";
                                        poster29_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster29_voteBtn = document.getElementById('poster29-vote-btn');
                                        poster29_voteBtn.disabled = false;
                                        poster29_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="posters-card">
                            <img class="poster-image" src="https://streamres.com/stream/posters/Vietnam.png">
                            <div class="devider"></div>
                            <div class="devider"></div>
                            <div class="poster-votebox">
                                <img class="poster-votebox-icon" src="https://streamres.com/stream/images/like-heart.png">
                                <p class="poster-votebox-votes" id="poster30-votes-num"><?php echo(number_format($poster['item30'])); ?></p>
                            </div>
                            <button type="button" class="poster-vote-btn" id="poster30-vote-btn" onclick="votePosterItem30()">I Believe & Like This</button>
                            <?php 
                                if ($user['poster_daily_vote'] < 1) {
                            ?>
                                    <script>
                                        var poster30_voteBtn = document.getElementById('poster30-vote-btn');
                                        poster30_voteBtn.disabled = true;
                                        poster30_voteBtn.style.backgroundColor = "#212A33";
                                        poster30_voteBtn.innerHTML  = "Next time random";
                                    </script>
                            <?php
                                } else {
                            ?>
                                    <script>
                                        var poster30_voteBtn = document.getElementById('poster30-vote-btn');
                                        poster30_voteBtn.disabled = false;
                                        poster30_voteBtn.style.backgroundColor = "#248BDA";
                                    </script>
                            <?php
                                }
                            ?>
                        </div>

                    </div>
                    
                    <div class="page-finish-devider"></div>

                </div>






                <div class="page3"> <!-- Products -->
                
                    <img class="product-page-photo" src="https://streamres.com/stream/images/product_icon.png">
                    
                    <p class="product-title">P R O D U C T S</p>
                    
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <p class="product-name">PRODUCTS AND AFFILIATE</p>
                    <p class="product-desc">In phase 2, Stream will become an online shop platform for companies and brands to market and sell their products or services through our application. This is a very special opportunity for you to earn through affiliate sales, dropshipping or affiliate marketing. So in addition to the airdrop, affiliate program will be the main source of your income.</p>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <img class="coming-soon-photo" src="https://streamres.com/stream/images/coming-soon.png">

                    <!--
                    <div class="level-frame">
                        <div class="level-cards">
                            <div class="level-image-box">
                                <img class="level-image" src="https://streamres.com/stream/images/levelsIcon.png">
                            </div>
                            <div class="level-card-right">
                                <p class="level-title-name">Level 1: Associate</p>
                                <div class"level-desc-box">
                                    <img class="level-desc-icon" src="https://streamres.com/stream/images/check-icon.png">
                                    <span class="level-desc-title">Rank:&nbsp;</span>
                                    <span class="level-desc-amount">1,000,000+</span>
                                </div>
                                <div class"level-desc-box">
                                    <img class="level-desc-icon" src="https://streamres.com/stream/images/check-icon.png">
                                    <span class="level-desc-title">Points Per Vote:&nbsp;</span>
                                    <span class="level-desc-amount">10</span>
                                </div>
                                <div class"level-desc-box">
                                    <img class="level-desc-icon" src="https://streamres.com/stream/images/check-icon.png">
                                    <span class="level-desc-title">Minimum Airdrop:&nbsp;</span>
                                    <span class="level-desc-amount">TBA</span>
                                </div>
                            </div>
                        </div>

                    </div>
                    -->
                    
                    <!--
                    <p class="level-desc">Levels determine your minimum and maximum rewards from the project airdrops. In addition, the number of points you receive per vote is calculated based on the level you are at. Levels are also very crucial in your monthly income during the main phase of the project (i.e. after the end of the airdrop).</p>
                    <div class="devider"></div>
                    <p class="level-desc">We have two very big competitive advantages compared to other similar projects; First, our airdrop is a minimum of $1000+ for each active user without forcing them to do crazy clicks or perform ridiculous tasks (read the description of each level). Second, we have defined a real economic application for the STREAM app in partnership with the world's top brands in order to receive a major part of their digital marketing budget and allocate monthly salaries to the active users in the main phase. This means a inimum of $10000 monthly income for the active users in addition to the increasing price of the $STM token. We will publish more details in time.</p>
                    -->
                    
                    <div class="page-finish-devider"></div>
                    
                </div>





                <div class="page4"> <!-- Synergy -->
                    
                    <img class="synergy-page-photo" src="https://streamres.com/stream/images/synergy-icon.png">
                    
                    <p class="synergy-title">S Y N E R G Y</p>

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <p class="synergy-bonuses">REFERRAL PROGRAM</p>
                    <p class="synergy-desc">Invite friends and get %20 of their earnings. This will also help you to raise your rank significantly.</p>

                    <div class="devider"></div>
                    
                    <div class="synergy-frame">
                        <div class="synergy-card">
                            <p class="synergy-invited">Friends Invited</p>
                            <div class="synergy-number-box">
                                <img class="synergy-number-icon" src="https://streamres.com/stream/images/friends-invited.png">
                                <p class="synergy-number" id="friends-number-id"><?php echo(number_format($user['referrals'])); ?></p>
                            </div>
                            <bottun class="copy-invitelink-btn" onclick="copyLink()">Copy Invitation Link</bottun>
                       </div>
                        
                        <div class="devider"></div>
                        <div class="devider"></div>
                        <div class="devider"></div>
                        <div class="devider"></div>
                        <p class="synergy-bonuses">AFFILIATE PROGRAM</p>
                        <p class="synergy-desc">Become our affiliate with a monthly income of at least $5000. No limit to the maximum income.</p>
                    
                        <div class="devider"></div>

                        <div class="affiliate-card">
                            <p class="affiliate-income-title">Total Income</p>
                            <div class="affiliate-income-box">
                                <img class="affiliate-income-icon" src="https://streamres.com/stream/images/usdt-icon.png">
                                <p class="affiliate-income-amount">0.00 USDT</p>
                            </div>
                            <bottun class="affiliate-btn" onclick="affiliateBtn()">Become Our Affiliate</bottun>
                       </div>
                        
                    </div>

                    <div class="page-finish-devider"></div>
                    
                </div>





                <div class="page5"> <!-- Overview -->

                    <img class="overview-page-photo" src="https://streamres.com/stream/images/overview-page-photo.png">
                    
                    <p class="overview-title">O V E R V I E W</p>

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <div class="user-stats">
                        <div class="user-stats-boxes">
                            <p class="stats-title">MY RANK:&nbsp;</p>
                            <p class="stats-amount" id="user-rank"><?php echo(number_format($rank['rank'])); ?></p>
                        </div>
                        <div class="user-stats-boxes">
                            <p class="stats-title">MY POINTS:&nbsp;</p>
                            <p class="stats-amount" id="user-points"><?php echo(number_format($user['points'])); ?></p>
                        </div>
                    </div>
                    
                    <div class="devider"></div>

                    <bottun class="boost-rank-btn" onclick="boostRankBtn()">
                        <span class="boost-icon"><ion-icon name="arrow-up-circle"></ion-icon></span>
                        <span class="boost-rank-text">Boost Your Rank</span>
                    </bottun>

                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>
                    <div class="devider"></div>

                    <div class="overview-frame">
                        
                        <p class="overview-airdrop-title">AIRDROP & AFFILIATE OVERVIEW</p>
                        
                        <div class="airdrop-overview-box">
                            
                            <p class="airdrop-rank-name">RANK: 1 - 1,000</p>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Minimum Airdrop: $20,000+</span>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Affiliate Program: $30,000+ Monthly</span>
                            <div class="devider"></div>
                            
                            <p class="airdrop-rank-name">RANK: 1,001 - 10,000</p>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Minimum Airdrop: $4,000+</span>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Affiliate Program: $20,000+ Monthly</span>
                            <div class="devider"></div>

                            <p class="airdrop-rank-name">RANK: 10,001 - 100,000</p>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Minimum Airdrop: $2,000+</span>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Affiliate Program: $8,000+ Monthly</span>
                            <div class="devider"></div>

                            <p class="airdrop-rank-name">RANK: 100,001 - 200,000</p>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Minimum Airdrop: $800+</span>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Affiliate Program: $6,000+ Monthly</span>
                            <div class="devider"></div>

                            <p class="airdrop-rank-name">RANK: 200,001 - 1,000,000</p>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Minimum Airdrop: $400+</span>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Affiliate Program: $5,000+ Monthly</span>
                            <div class="devider"></div>

                            <p class="airdrop-rank-name">RANK: 1,000,000+</p>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Minimum Airdrop: TBA</span>
                            <span class="airdrop-amount"><img class="airdrop-check-icon" src="https://streamres.com/stream/images/check-icon.png">&nbsp;&nbsp;Affiliate Program: $5,000+ Monthly</span>
                            <div class="devider"></div>

                        </div>

                        <div class="devider"></div>
                        <div class="devider"></div>
                        <div class="devider"></div>

                        <p class="overview-roadmap-title">ROADMAP OVERVIEW</p>
                        <div class="roadmap-overview-card">
                            <img class="roadmap-icon" src="https://streamres.com/stream/images/roadmap.png">
                        </div>
                        <div class="devider"></div>
                        <div class="devider"></div>
                        <div class="devider"></div>
                        <p class="overview-desc">The figure above shows the roadmap of the Stream project. If you check the roadmap carefully, you will notice some secret information that we will reveal later. According to the figure, after the formation of the idea and also launch of the application, all activities related to airdrop are carried out, which is the same as phase 1. On the other hand, Phase 2 which is the project core, includes a sort of measures related to the supply and sales of products coming from a number of famous brands and companies. According to the picture, the Stream app will be redesigned to fully cover the usecases of phase 2. This time is the best opportunity for you to prepare yourself for the affiliate program and benefit from a monthly income of at least $5000.</p>
                    
                    </div>

                    <div class="page-finish-devider"></div>

                </div>

            </div>
            
        </div>





        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>


        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>


        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.querySelector('#button-page1').onclick = function() {
                    document.querySelector('.page1').style.display = 'flex';
                    document.querySelector('.page2').style.display = 'none';
                    document.querySelector('.page3').style.display = 'none';
                    document.querySelector('.page4').style.display = 'none';
                    document.querySelector('.page5').style.display = 'none';
                }
                document.querySelector('#button-page2').onclick = function() {
                    document.querySelector('.page1').style.display = 'none';
                    document.querySelector('.page2').style.display = 'flex';
                    document.querySelector('.page3').style.display = 'none';
                    document.querySelector('.page4').style.display = 'none';
                    document.querySelector('.page5').style.display = 'none';
                }
                document.querySelector('#button-page3').onclick = function() {
                    document.querySelector('.page1').style.display = 'none';
                    document.querySelector('.page2').style.display = 'none';
                    document.querySelector('.page3').style.display = 'flex';
                    document.querySelector('.page4').style.display = 'none';
                    document.querySelector('.page5').style.display = 'none';
                }
                document.querySelector('#button-page4').onclick = function() {
                    document.querySelector('.page1').style.display = 'none';
                    document.querySelector('.page2').style.display = 'none';
                    document.querySelector('.page3').style.display = 'none';
                    document.querySelector('.page4').style.display = 'flex';
                    document.querySelector('.page5').style.display = 'none';
                }
                document.querySelector('#button-page5').onclick = function() {
                    document.querySelector('.page1').style.display = 'none';
                    document.querySelector('.page2').style.display = 'none';
                    document.querySelector('.page3').style.display = 'none';
                    document.querySelector('.page4').style.display = 'none';
                    document.querySelector('.page5').style.display = 'flex';
                }
            });
        </script>

        
        <script>
            function showGiftPopup() {
                document.querySelector('.gift-popup').style.display = 'flex';
            }
            function closeGiftPopup() {
                document.querySelector('.gift-popup').style.display = 'none';
            }
            
            function showGiftActivePopup() {
                document.querySelector('.gift-active-popup').style.display = 'flex';
            }
            function closeGiftActivePopup() {
                document.querySelector('.gift-active-popup').style.display = 'none';
            }
            
            function joinTG() {
                window.location.href = 'https://t.me/streamappnews';
            }

            function showX8Popup() {
                document.querySelector('.x8-popup').style.display = 'flex';
            }
            function closeX8Popup() {
                document.querySelector('.x8-popup').style.display = 'none';
            }
            /*
            function showX3Popup() {
                document.querySelector('.x3-popup').style.display = 'flex';
            }
            function closeX3Popup() {
                document.querySelector('.x3-popup').style.display = 'none';
            }
            */
        </script>


        <script>
            const list = document.querySelectorAll('.list');
            function activeLink() {
                list.forEach((item) =>
                item.classList.remove('active'));
                this.classList.add('active');
            }
            list.forEach((item) =>
            item.addEventListener('click',activeLink));
        </script>


        <script>
            Telegram.WebApp.ready();
            Telegram.WebApp.expand();
        </script>


        <script>
        
            let text = 'https://t.me/streamresbot?start=' + <?php echo($user['telegramID']) ?>;
            const copyLink = async () => {
                try {
                    await navigator.clipboard.writeText(text);
                    document.querySelector('.copy-invitelink-btn').textContent = "Copied!";
                    document.querySelector('.copy-invitelink-btn').style.backgroundColor = "#273646";
                    setTimeout(function() {
                    document.querySelector('.copy-invitelink-btn').textContent = "Copy Invitation Link";
                        document.querySelector('.copy-invitelink-btn').style.backgroundColor = "#248BDA";
                    }, 300);
                } catch (err) {
                    document.querySelector('.copy-invitelink-btn').textContent = "Error!";
                    document.querySelector('.copy-invitelink-btn').style.backgroundColor = "#2C2C2C";
                }
            }

            function affiliateBtn() {
                document.querySelector('.affiliate-btn').textContent = "Wait Until Phase 2";
                document.querySelector('.affiliate-btn').style.backgroundColor = "#273646";
                setTimeout(function() {
                document.querySelector('.affiliate-btn').textContent = "Become Our Affiliate";
                    document.querySelector('.affiliate-btn').style.backgroundColor = "#248BDA";
                }, 1000);
            }
            
            function boostRankBtn() {
                document.querySelector('.boost-rank-text').textContent = "Coming soon";
                document.querySelector('.boost-rank-btn').style.backgroundColor = "#273646";
                setTimeout(function() {
                document.querySelector('.boost-rank-text').textContent = "Boost Your Rank";
                    document.querySelector('.boost-rank-btn').style.backgroundColor = "#248BDA";
                }, 1000);
                
            }
            
        </script>

        <!--
        <script>
        
            x = setInterval(function() {
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'lastVotes.php',
                    data: { user_chat_id: dddddddddddddddddddddddddddddddddddddd },
                    success: function(response) {

                        var response = JSON.parse(response);
                        
                        document.getElementById('user-rank').innerHTML = Number(response.user_rank).toLocaleString();
                        /*document.getElementById('user-level').innerHTML = Number(response.user_level).toLocaleString();*/
                        document.getElementById('user-points').innerHTML = Number(response.user_points).toLocaleString();
                        document.getElementById('friends-number-id').innerHTML = Number(response.user_refs).toLocaleString();

                        document.getElementById('stream01-votes-num').innerHTML = Number(response.stream_item01).toLocaleString();
                        document.getElementById('stream02-votes-num').innerHTML = Number(response.stream_item02).toLocaleString();

                        document.getElementById('poster01-votes-num').innerHTML = Number(response.poster_item01).toLocaleString();
                        document.getElementById('poster02-votes-num').innerHTML = Number(response.poster_item02).toLocaleString();
                        document.getElementById('poster03-votes-num').innerHTML = Number(response.poster_item03).toLocaleString();
                        document.getElementById('poster04-votes-num').innerHTML = Number(response.poster_item04).toLocaleString();
                        document.getElementById('poster05-votes-num').innerHTML = Number(response.poster_item05).toLocaleString();
                        document.getElementById('poster06-votes-num').innerHTML = Number(response.poster_item06).toLocaleString();
                        document.getElementById('poster07-votes-num').innerHTML = Number(response.poster_item07).toLocaleString();
                        document.getElementById('poster08-votes-num').innerHTML = Number(response.poster_item08).toLocaleString();
                        document.getElementById('poster09-votes-num').innerHTML = Number(response.poster_item09).toLocaleString();
                        document.getElementById('poster10-votes-num').innerHTML = Number(response.poster_item10).toLocaleString();
                        document.getElementById('poster11-votes-num').innerHTML = Number(response.poster_item11).toLocaleString();
                        document.getElementById('poster12-votes-num').innerHTML = Number(response.poster_item12).toLocaleString();
                        document.getElementById('poster13-votes-num').innerHTML = Number(response.poster_item13).toLocaleString();
                        document.getElementById('poster14-votes-num').innerHTML = Number(response.poster_item14).toLocaleString();
                        document.getElementById('poster15-votes-num').innerHTML = Number(response.poster_item15).toLocaleString();
                        document.getElementById('poster16-votes-num').innerHTML = Number(response.poster_item16).toLocaleString();
                        document.getElementById('poster17-votes-num').innerHTML = Number(response.poster_item17).toLocaleString();
                        document.getElementById('poster18-votes-num').innerHTML = Number(response.poster_item18).toLocaleString();
                        document.getElementById('poster19-votes-num').innerHTML = Number(response.poster_item19).toLocaleString();
                        document.getElementById('poster20-votes-num').innerHTML = Number(response.poster_item20).toLocaleString();
                        document.getElementById('poster21-votes-num').innerHTML = Number(response.poster_item21).toLocaleString();
                        document.getElementById('poster22-votes-num').innerHTML = Number(response.poster_item22).toLocaleString();
                        document.getElementById('poster23-votes-num').innerHTML = Number(response.poster_item23).toLocaleString();
                        document.getElementById('poster24-votes-num').innerHTML = Number(response.poster_item24).toLocaleString();
                        document.getElementById('poster25-votes-num').innerHTML = Number(response.poster_item25).toLocaleString();
                        document.getElementById('poster26-votes-num').innerHTML = Number(response.poster_item26).toLocaleString();
                        document.getElementById('poster27-votes-num').innerHTML = Number(response.poster_item27).toLocaleString();
                        document.getElementById('poster28-votes-num').innerHTML = Number(response.poster_item28).toLocaleString();
                        document.getElementById('poster29-votes-num').innerHTML = Number(response.poster_item29).toLocaleString();
                        document.getElementById('poster30-votes-num').innerHTML = Number(response.poster_item30).toLocaleString();
                        
                    }
                });
            }, 5000);

        </script>
        -->

        <script>
        
            function voteStreamItem01() {

                document.getElementById('stream01-vote-btn').disabled = true;
                document.getElementById('stream01-vote-btn').style.backgroundColor = "#212A33";
                document.getElementById('stream01-vote-btn').innerHTML  = "Next time random";
                document.getElementById('stream02-vote-btn').disabled = true;
                document.getElementById('stream02-vote-btn').style.backgroundColor = "#212A33";
                document.getElementById('stream02-vote-btn').innerHTML  = "Next time random";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingStreamItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , item: 'Item01' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var item01_votes_number = Number(response.item_votes_number);

                        document.getElementById('stream01-votes-num').innerHTML = Number(item01_votes_number).toLocaleString();

                        const distance = user_points_after_vote - user_points_before_vote;
                        var counter = 1;
                        up = setInterval(() => {
                            user_new_points = user_points_before_vote + counter;
                            document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                            if (counter >= distance) {
                                clearInterval(up);
                            }
                            counter += 1;
                        }, 50);
                        
                    }
                });
            }

            function voteStreamItem02() {

                document.getElementById('stream01-vote-btn').disabled = true;
                document.getElementById('stream01-vote-btn').style.backgroundColor = "#212A33";
                document.getElementById('stream01-vote-btn').innerHTML  = "Next time random";
                document.getElementById('stream02-vote-btn').disabled = true;
                document.getElementById('stream02-vote-btn').style.backgroundColor = "#212A33";
                document.getElementById('stream02-vote-btn').innerHTML  = "Next time random";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingStreamItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , item: 'Item02' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var item02_votes_number = Number(response.item_votes_number);

                        document.getElementById('stream02-votes-num').innerHTML = Number(item02_votes_number).toLocaleString();

                        const distance = user_points_after_vote - user_points_before_vote;
                        var counter = 1;
                        up = setInterval(() => {
                            user_new_points = user_points_before_vote + counter;
                            document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                            if (counter >= distance) {
                                clearInterval(up);
                            }
                            counter += 1;
                        }, 50);

                    }
                });
            }

        </script>


        <script>
        
            function votePosterItem01() {

                document.getElementById('poster01-vote-btn').disabled = true;
                document.getElementById('poster01-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster01-vote-btn').innerHTML  = "Done!";
                
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster01' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster01_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);
                        
                        document.getElementById('poster01-votes-num').innerHTML = Number(poster01_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster01-vote-btn').disabled = false;
                                document.getElementById('poster01-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster01-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);

                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem02() {

                document.getElementById('poster02-vote-btn').disabled = true;
                document.getElementById('poster02-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster02-vote-btn').innerHTML  = "Done!";
                
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster02' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster02_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster02-votes-num').innerHTML = Number(poster02_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster02-vote-btn').disabled = false;
                                document.getElementById('poster02-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster02-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem03() {

                document.getElementById('poster03-vote-btn').disabled = true;
                document.getElementById('poster03-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster03-vote-btn').innerHTML  = "Done!";
                
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster03' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster03_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster03-votes-num').innerHTML = Number(poster03_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster03-vote-btn').disabled = false;
                                document.getElementById('poster03-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster03-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem04() {

                document.getElementById('poster04-vote-btn').disabled = true;
                document.getElementById('poster04-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster04-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster04' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster04_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster04-votes-num').innerHTML = Number(poster04_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster04-vote-btn').disabled = false;
                                document.getElementById('poster04-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster04-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem05() {

                document.getElementById('poster05-vote-btn').disabled = true;
                document.getElementById('poster05-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster05-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster05' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster05_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster05-votes-num').innerHTML = Number(poster05_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster05-vote-btn').disabled = false;
                                document.getElementById('poster05-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster05-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem06() {

                document.getElementById('poster06-vote-btn').disabled = true;
                document.getElementById('poster06-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster06-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster06' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster06_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster06-votes-num').innerHTML = Number(poster06_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster06-vote-btn').disabled = false;
                                document.getElementById('poster06-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster06-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem07() {

                document.getElementById('poster07-vote-btn').disabled = true;
                document.getElementById('poster07-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster07-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster07' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster07_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster07-votes-num').innerHTML = Number(poster07_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster07-vote-btn').disabled = false;
                                document.getElementById('poster07-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster07-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem08() {

                document.getElementById('poster08-vote-btn').disabled = true;
                document.getElementById('poster08-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster08-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster08' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster08_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster08-votes-num').innerHTML = Number(poster08_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster08-vote-btn').disabled = false;
                                document.getElementById('poster08-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster08-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem09() {

                document.getElementById('poster09-vote-btn').disabled = true;
                document.getElementById('poster09-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster09-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster09' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster09_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster09-votes-num').innerHTML = Number(poster09_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster09-vote-btn').disabled = false;
                                document.getElementById('poster09-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster09-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem10() {

                document.getElementById('poster10-vote-btn').disabled = true;
                document.getElementById('poster10-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster10-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster10' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster10_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster10-votes-num').innerHTML = Number(poster10_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster10-vote-btn').disabled = false;
                                document.getElementById('poster10-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster10-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem11() {

                document.getElementById('poster11-vote-btn').disabled = true;
                document.getElementById('poster11-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster11-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster11' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster11_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster11-votes-num').innerHTML = Number(poster11_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster11-vote-btn').disabled = false;
                                document.getElementById('poster11-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster11-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem12() {

                document.getElementById('poster12-vote-btn').disabled = true;
                document.getElementById('poster12-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster12-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster12' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster12_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster12-votes-num').innerHTML = Number(poster12_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster12-vote-btn').disabled = false;
                                document.getElementById('poster12-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster12-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem13() {

                document.getElementById('poster13-vote-btn').disabled = true;
                document.getElementById('poster13-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster13-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster13' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster13_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster13-votes-num').innerHTML = Number(poster13_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster13-vote-btn').disabled = false;
                                document.getElementById('poster13-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster13-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem14() {

                document.getElementById('poster14-vote-btn').disabled = true;
                document.getElementById('poster14-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster14-vote-btn').innerHTML  = "Done!";
                
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster14' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster14_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster14-votes-num').innerHTML = Number(poster14_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster14-vote-btn').disabled = false;
                                document.getElementById('poster14-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster14-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem15() {

                document.getElementById('poster15-vote-btn').disabled = true;
                document.getElementById('poster15-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster15-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster15' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster15_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster15-votes-num').innerHTML = Number(poster15_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster15-vote-btn').disabled = false;
                                document.getElementById('poster15-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster15-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem16() {

                document.getElementById('poster16-vote-btn').disabled = true;
                document.getElementById('poster16-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster16-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster16' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster16_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster16-votes-num').innerHTML = Number(poster16_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster16-vote-btn').disabled = false;
                                document.getElementById('poster16-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster16-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem17() {

                document.getElementById('poster17-vote-btn').disabled = true;
                document.getElementById('poster17-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster17-vote-btn').innerHTML  = "Done!";
                
                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster17' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster17_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster17-votes-num').innerHTML = Number(poster17_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster17-vote-btn').disabled = false;
                                document.getElementById('poster17-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster17-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem18() {

                document.getElementById('poster18-vote-btn').disabled = true;
                document.getElementById('poster18-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster18-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster18' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster18_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster18-votes-num').innerHTML = Number(poster18_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster18-vote-btn').disabled = false;
                                document.getElementById('poster18-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster18-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem19() {

                document.getElementById('poster19-vote-btn').disabled = true;
                document.getElementById('poster19-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster19-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster19' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster19_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster19-votes-num').innerHTML = Number(poster19_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster19-vote-btn').disabled = false;
                                document.getElementById('poster19-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster19-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem20() {

                document.getElementById('poster20-vote-btn').disabled = true;
                document.getElementById('poster20-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster20-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster20' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster20_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster20-votes-num').innerHTML = Number(poster20_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster20-vote-btn').disabled = false;
                                document.getElementById('poster20-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster20-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem21() {

                document.getElementById('poster21-vote-btn').disabled = true;
                document.getElementById('poster21-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster21-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster21' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster21_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster21-votes-num').innerHTML = Number(poster21_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster21-vote-btn').disabled = false;
                                document.getElementById('poster21-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster21-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem22() {

                document.getElementById('poster22-vote-btn').disabled = true;
                document.getElementById('poster22-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster22-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster22' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster22_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster22-votes-num').innerHTML = Number(poster22_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster22-vote-btn').disabled = false;
                                document.getElementById('poster22-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster22-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem23() {

                document.getElementById('poster23-vote-btn').disabled = true;
                document.getElementById('poster23-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster23-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster23' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster23_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster23-votes-num').innerHTML = Number(poster23_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster23-vote-btn').disabled = false;
                                document.getElementById('poster23-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster23-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem24() {

                document.getElementById('poster24-vote-btn').disabled = true;
                document.getElementById('poster24-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster24-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster24' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster24_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster24-votes-num').innerHTML = Number(poster24_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster24-vote-btn').disabled = false;
                                document.getElementById('poster24-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster24-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem25() {

                document.getElementById('poster25-vote-btn').disabled = true;
                document.getElementById('poster25-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster25-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster25' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster25_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster25-votes-num').innerHTML = Number(poster25_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster25-vote-btn').disabled = false;
                                document.getElementById('poster25-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster25-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem26() {

                document.getElementById('poster26-vote-btn').disabled = true;
                document.getElementById('poster26-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster26-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster26' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster26_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster26-votes-num').innerHTML = Number(poster26_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster26-vote-btn').disabled = false;
                                document.getElementById('poster26-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster26-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem27() {

                document.getElementById('poster27-vote-btn').disabled = true;
                document.getElementById('poster27-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster27-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster27' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster27_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster27-votes-num').innerHTML = Number(poster27_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster27-vote-btn').disabled = false;
                                document.getElementById('poster27-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster27-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem28() {

                document.getElementById('poster28-vote-btn').disabled = true;
                document.getElementById('poster28-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster28-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster28' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster28_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster28-votes-num').innerHTML = Number(poster28_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster28-vote-btn').disabled = false;
                                document.getElementById('poster28-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster28-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem29() {

                document.getElementById('poster29-vote-btn').disabled = true;
                document.getElementById('poster29-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster29-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster29' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster29_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster29-votes-num').innerHTML = Number(poster29_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster29-vote-btn').disabled = false;
                                document.getElementById('poster29-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster29-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

            function votePosterItem30() {

                document.getElementById('poster30-vote-btn').disabled = true;
                document.getElementById('poster30-vote-btn').style.backgroundColor = "#1F7EC6";
                document.getElementById('poster30-vote-btn').innerHTML  = "Done!";

                $.ajax({
                    type: 'POST',
                    cache: false,
                    url: 'votingPosterItems.php',
                    data: { user_chat_id: <?php echo($user['telegramID']); ?> , poster: 'Poster30' },
                    success: function(response) {

                        var response = JSON.parse(response);
                        var user_points_after_vote = Number(response.user_points_after_vote);
                        var user_points_before_vote = Number(response.user_points_before_vote);
                        var poster30_votes_number = Number(response.poster_votes_number);
                        var user_pos_daily_votes = Number(response.user_pos_daily_votes);

                        document.getElementById('poster30-votes-num').innerHTML = Number(poster30_votes_number).toLocaleString();

                        if (user_pos_daily_votes < 1) {
                            document.getElementById('poster01-vote-btn').disabled = true;
                            document.getElementById('poster01-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster01-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster02-vote-btn').disabled = true;
                            document.getElementById('poster02-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster02-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster03-vote-btn').disabled = true;
                            document.getElementById('poster03-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster03-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster04-vote-btn').disabled = true;
                            document.getElementById('poster04-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster04-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster05-vote-btn').disabled = true;
                            document.getElementById('poster05-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster05-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster06-vote-btn').disabled = true;
                            document.getElementById('poster06-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster06-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster07-vote-btn').disabled = true;
                            document.getElementById('poster07-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster07-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster08-vote-btn').disabled = true;
                            document.getElementById('poster08-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster08-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster09-vote-btn').disabled = true;
                            document.getElementById('poster09-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster09-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster10-vote-btn').disabled = true;
                            document.getElementById('poster10-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster10-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster11-vote-btn').disabled = true;
                            document.getElementById('poster11-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster11-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster12-vote-btn').disabled = true;
                            document.getElementById('poster12-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster12-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster13-vote-btn').disabled = true;
                            document.getElementById('poster13-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster13-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster14-vote-btn').disabled = true;
                            document.getElementById('poster14-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster14-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster15-vote-btn').disabled = true;
                            document.getElementById('poster15-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster15-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster16-vote-btn').disabled = true;
                            document.getElementById('poster16-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster16-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster17-vote-btn').disabled = true;
                            document.getElementById('poster17-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster17-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster18-vote-btn').disabled = true;
                            document.getElementById('poster18-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster18-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster19-vote-btn').disabled = true;
                            document.getElementById('poster19-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster19-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster20-vote-btn').disabled = true;
                            document.getElementById('poster20-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster20-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster21-vote-btn').disabled = true;
                            document.getElementById('poster21-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster21-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster22-vote-btn').disabled = true;
                            document.getElementById('poster22-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster22-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster23-vote-btn').disabled = true;
                            document.getElementById('poster23-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster23-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster24-vote-btn').disabled = true;
                            document.getElementById('poster24-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster24-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster25-vote-btn').disabled = true;
                            document.getElementById('poster25-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster25-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster26-vote-btn').disabled = true;
                            document.getElementById('poster26-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster26-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster27-vote-btn').disabled = true;
                            document.getElementById('poster27-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster27-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster28-vote-btn').disabled = true;
                            document.getElementById('poster28-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster28-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster29-vote-btn').disabled = true;
                            document.getElementById('poster29-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster29-vote-btn').innerHTML  = "Next time random";
                            document.getElementById('poster30-vote-btn').disabled = true;
                            document.getElementById('poster30-vote-btn').style.backgroundColor = "#212A33";
                            document.getElementById('poster30-vote-btn').innerHTML  = "Next time random";
                        } else {
                            setTimeout(function() {
                                document.getElementById('poster30-vote-btn').disabled = false;
                                document.getElementById('poster30-vote-btn').style.backgroundColor = "#248BDA";
                                document.getElementById('poster30-vote-btn').innerHTML  = "I Believe & Like This";
                            }, 700);
                            
                            const distance = user_points_after_vote - user_points_before_vote;
                            var counter = 1;
                            up = setInterval(() => {
                                user_new_points = user_points_before_vote + counter;
                                document.querySelector('.header-userpoints-number').innerHTML  = user_new_points.toLocaleString();
                                if (counter >= distance) {
                                    clearInterval(up);
                                }
                                counter += 1;
                            }, 50);
                            
                        }
                    }
                });
            }

        </script>

<!--
        <script> /* Claim timer */
        
            var h = document.getElementById("hours");
            var m = document.getElementById("minutes");
            var s = document.getElementById("seconds");
            
            const userClaimTime = new Date('.........................................').getTime();

            const msInSecond = 1000;
            const msInMinute = msInSecond * 60;
            const msInHour = msInMinute * 60;
            const msInDay = msInHour * 24;

            var x = setInterval(() => {
                const distance = userClaimTime - new Date().getTime();
                const remainDays = Math.floor(distance/msInDay);
                const remainHours = Math.floor(distance % msInDay / msInHour);
                const remainMinutes = Math.floor(distance % msInHour / msInMinute);
                const remainSeconds = Math.floor(distance % msInMinute / msInSecond);

                if (distance > 0) {
                    if (remainHours < 10) {
                        h.innerHTML = "0" + remainHours;
                    } else {
                        h.innerHTML = remainHours;
                    }
                    if (remainMinutes < 10) {
                        m.innerHTML = "0" + remainMinutes;
                    } else {
                        m.innerHTML = remainMinutes;
                    }
                    if (remainSeconds < 10) {
                        s.innerHTML = "0" + remainSeconds;
                    } else {
                        s.innerHTML = remainSeconds;
                    }
                } else {
                    document.getElementById("timer").style.backgroundColor ="#fff";
                    h.innerHTML = "00";
                    m.innerHTML = "00";
                    s.innerHTML = "00";
                    clearInterval(x);
                }
            }, 1000);

        </script>
-->      


        <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

        <script>
            $(window).on("load", function() {
                $(".loading").fadeOut(200, function() {
                    $(".content").fadeIn(200);
                });
            });
        </script>

    </body>

</html>
