<?php

require_once('config.php');
require_once('telegram_json.php');
require_once('Classes/DBConnection.php');
require_once('Classes/DB.php');
require_once('Classes/TelegramService.php');
require_once('Classes/Telegram.php');
require_once('helper.php');

use Classes\DB;
use Classes\Telegram;


global $db;
global $telegram;
global $user;
global $base;
global $deposit_hash;
global $double_hash;
global $double_address;


$db = new DB();
$telegram = new Telegram();
$double_hash = 0;
$double_address = 0;


$base = $db->table('BASE')->where('id', 1)->first();

$user = $db->table('USERS')->where('telegramID', '103103103')->first();
// $user = $db->table('USERS')->where('telegramID', $chat_id)->first();

/*
$deposit_hash = $db->table('HASHES')->where('UsTgId', $chat_id)->where('runDay', $base['runDay'])->first();


if (empty($user)) {
    
    $db->table('USERS')->insert(['UsTgId'], [$chat_id]);
    $user = $db->table('USERS')->where('UsTgId', $chat_id)->first();
}

if (empty($deposit_hash) && !$user['isAdmin']) {
    
    $db->table('HASHES')->insert(['runDay', 'UsTgId'], [$base['runDay'], $user['UsTgId']]);
    $deposit_hash = $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->first();
}


if (str_contains($text, '/start')) {

    $text_send = '❇️ به ربات استارک خوش آمدید.' . "\n\n";
    $db->table('USERS')->where('UsTgId', $chat_id)->update(['WalFlag'], [0]);
    $db->table('HASHES')->where('UsTgId', $user['UsTgId'])->where('runDay', $base['runDay'])->update(['part_flag'], [0]);

    if (str_contains($text, '/start ')) {
        
        $refer = str_replace("/start ","", $text);
        $before_referred = $db->table('REFERRALS')->where('referral', $chat_id)->first();
        if (empty($before_referred) && $refer != $chat_id) {
            
            $db->table('REFERRALS')->insert(['referrer', 'referral'], [$refer, $chat_id]);
            $userRefsNum = $db->table('USERS')->where('UsTgId', $refer)->first();
            $db->table('USERS')->where('UsTgId', $refer)->update(['RefsNum'], [$userRefsNum['RefsNum'] + 1]);
            
        }

    } else {
        $before_referred = $db->table('REFERRALS')->where('referral', $chat_id)->first();
        if (empty($before_referred)) {
            $db->table('REFERRALS')->insert(['referrer', 'referral'], ['0000000000', $chat_id]);
        }
    }

    $text_send = 'Welcome' . "\n\n";
}
*/

?>

<!DOCTYPE html>

<html lang="en-US">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Yazak</title>
        <link rel="stylesheet" href="style.css">
    </head>

    <body>
        
        <div class="loading">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>

        <div class="content">
            
            <div class="navigation">
                <ul>
                    <li class="list">
                        <button type="button" id="button-page1">
                            <span class="icon"><ion-icon name="wallet"></ion-icon></span>
                            <span class="text">Profile</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page2">
                            <span class="icon"><ion-icon name="mail"></ion-icon></span>
                            <span class="text">Invite</span>
                        </button>
                    </li>
                    <li class="list active">
                        <button type="button" id="button-page3">
                            <span class="icon"><ion-icon name="cube"></ion-icon></span>
                            <span class="text">Miners</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page4">
                            <span class="icon"><ion-icon name="logo-buffer"></ion-icon></span>
                            <span class="text">Energy</span>
                        </button>
                    </li>
                    <li class="list">
                        <button type="button" id="button-page5">
                            <span class="icon"><ion-icon name="speedometer"></ion-icon></span>
                            <span class="text">Stats</span>
                        </button>
                    </li>
                </ul>
            </div>

            <div class="pages-section"> <!-- Pages -->

                <div class="page1"> <!-- Page1 -->
                    <h2>Page 1.1</h2>
                </div>

                <div class="page2"> <!-- Page2 -->
                    <h2>Page 2.2</h2>
                </div>

                <div class="page3"> <!-- Page3 -->

                    <div class="card-balance">
                        <div class="top-section">
                            <div class="balance-box">
                                <h4>BALANCE</h4>
                            </div>
                            <div class="balance-amount">
                                <img class="balance-image" src="https://yazak.ir/Images/tether.png">
                                <p class="amount-value">
                                    <?php
                                        echo number_format($user['balance'], 2, '.', ',');
                                    ?>
                                </p>
                            </div>
                            <div class="top-buttons-section">
                                <ul>
                                    <li>
                                        <button type="button" class="deposit">
                                            <p>Deposit</p>
                                        </button>
                                    </li>
                                    <li>
                                        <button type="button" class="withdraw">
                                            <p>Withdraw</p>
                                        </button>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="bottom-section">
                            <span class="title">SPECIFICATIONS</span>
                            <div class="row row1">
                                <div class="item">
                                    <span class="big-text">
                                        <?php echo($user['hashAPY']); ?>
                                    </span>
                                    <span class="regular-text">HASH (APY)</span>
                                </div>
                                <div class="item">
                                    <?php
                                        if($user['energy'] == 1) {
                                            echo '<span class="big-text">FULL</span>';
                                        } else {
                                            echo '<span class="energy-empty">EMPTY</span>';
                                        }
                                    ?>
                                    <span class="regular-text">ENERGY</span>
                                </div>
                                <div class="item">
                                    <span class="big-text" id="mining-Rate-Element">1.00</span>
                                    <span class="regular-text">MINING RATE</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="devider"></div>
                    
                    <div class="claim-message">
                        Claim Result Message!
                    </div>

                    <div class="card-claim">
                        <div class="mining-status">
                            <div class="l"></div>
                            <div class="l"></div>
                            <div class="l"></div>
                            <div class="l"></div>
                            <div class="l"></div>
                            <div class="l"></div>
                            <div class="l"></div>
                            <div class="l"></div>
                            <div class="l"></div>
                        </div>
                        <p>Claim your profit every 24 hours</p>
                        <div id="time">
                            <div>
                                <span id="hours">00</span>
                            </div>
                            <div>
                                <span id="minutes">00</span>
                            </div>
                            <div>
                                <span id="seconds">00</span>
                            </div>
                        </div>

<!---
                        <div class="section-countdown">
                            <time class="countdown-timer">
                                <span class="reel">
                                    <b class="digit timer-h0">2</b>
                                    <b class="digit timer-h1">3</b>
                                </span>
                                <span class="reel">
                                    <b class="digit timer-m0">5</b>
                                    <b class="digit timer-m1">9</b>
                                </span>
                                <span class="reel">
                                    <b class="digit timer-s0">6</b>
                                    <b class="digit timer-s1">0</b>
                                </span>
                            </time>
                        </div>
-->
                        <input type="submit" class="claim-button" value = "Claim Your Profit" onclick = "claimProfit();" disabled />
                    </div>
                    
                    <div class="devider"></div>

                    <div class="card-stats">
                        <div class="stats-section">
                            <span class="title">STATISTICS</span>
                            <div class="row row1">
                                <div class="item">
                                    <span class="big-text">
                                        <?php
                                            echo($base['totalUsers']);
                                        ?>
                                    </span>
                                    <span class="regular-text">TOTAL USERS</span>
                                </div>
                                <div class="item">
                                    <span class="big-text">
                                        <?php
                                            echo($base['dayUsers']);
                                        ?>
                                    </span>
                                    <span class="regular-text">DAY USERS</span>
                                </div>
                                <div class="item">
                                    <span class="big-text">
                                        <?php
                                            echo($base['totalInvested']);
                                        ?>
                                    </span>
                                    <span class="regular-text">INVESTED ($)</span>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="page4"> <!-- Page4 -->
                    <h2>Page 4.4</h2>
                </div>

                <div class="page5"> <!-- Page5 -->
                    <h2>Page 5.5</h2>
                </div>
            </div>
            
        </div>

        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
        <script src="script.js"></script>
        <script src="main.js"></script>

        <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

        <script>

            $(window).on("load", function() {
                $(".loading").fadeOut(200, function() {
                    $(".content").fadeIn(200);
                });
            });
            
        </script>

        <script> /* Mining rate */
        
            function setMiningRate() {
                var miningRateElement = document.getElementById("mining-Rate-Element");
                var miningRateChange = <?php echo $base['miningRate']; ?> + Math.floor((Math.random() * 7) -3)/100;
                if (miningRateChange == 1) {
                    miningRateElement.innerHTML = miningRateChange + ".00";
                } else {
                    miningRateElement.innerHTML = miningRateChange;
                }
            }
            setInterval(setMiningRate, 3000);
            
        </script> 

        <script> /* Claim timer */
        
            var h = document.getElementById("hours");
            var m = document.getElementById("minutes");
            var s = document.getElementById("seconds");
            
            const userClaimTime = new Date('<?php echo($user['claimTime']); ?>').getTime();

            const msInSecond = 1000;
            const msInMinute = msInSecond * 60;
            const msInHour = msInMinute * 60;
            const msInDay = msInHour * 24;

            var x = setInterval(() => {
                const distance = userClaimTime - new Date().getTime();
                const remainDays = Math.floor(distance/msInDay);
                const remainHours = Math.floor(distance % msInDay / msInHour);
                const remainMinutes = Math.floor(distance % msInHour / msInMinute);
                const remainSeconds = Math.floor(distance % msInMinute / msInSecond);

                if (distance > 0) {
                    if (remainHours < 10) {
                        h.innerHTML = "0" + remainHours;
                    } else {
                        h.innerHTML = remainHours;
                    }
                    if (remainMinutes < 10) {
                        m.innerHTML = "0" + remainMinutes;
                    } else {
                        m.innerHTML = remainMinutes;
                    }
                    if (remainSeconds < 10) {
                        s.innerHTML = "0" + remainSeconds;
                    } else {
                        s.innerHTML = remainSeconds;
                    }
                } else {
                    document.querySelector(".claim-button").style.backgroundColor ="#4db2ff";
                    document.querySelector(".claim-button").innerHTML = "Claim Your Profit";
                    document.querySelector(".claim-button").style.color ="#000";
                    document.querySelector(".claim-button").disabled = false;
                    clearInterval(x);
                }
            }, 1000);

        </script>
        
        <script type="text/javascript"> /* Claim Your Profit */

            function claimProfit() {
                $.ajax({
                    type: "POST",
                    url: 'claimajax.php',
                    data: $(this).serialize(),
                    success: function(response){
                        
                        $('.amount-value').html(Number(JSON.parse(response)).toFixed(2));
                        document.querySelector(".claim-button").setAttribute("value", "Please wait");
                        document.querySelector(".claim-button").style.backgroundColor = "#212E33";
                        document.querySelector(".claim-button").style.color = "gray";
                        document.querySelector(".claim-button").disabled = true;

                        $('.claim-message').html("Successfully claimed.");
                        $('.claim-message').show();
                        $('.claim-message').delay(500).show(10, function() {
                            $(this).delay(3000).hide(10, function() {
                                $(this).remove();
                            });
                        });
                    }
                });
            }

        </script>
       
    </body>

</html>
